﻿/*

 ********************************************************

 * Copyright (c) VMware, Inc.2010, 2016. All Rights Reserved.

 ********************************************************

 *

 * DISCLAIMER. THIS PROGRAM IS PROVIDED TO YOU "AS IS" WITHOUT

 * WARRANTIES OR CONDITIONS OF ANY KIND, WHETHER ORAL OR WRITTEN,

 * EXPRESS OR IMPLIED. THE AUTHOR SPECIFICALLY DISCLAIMS ANY IMPLIED

 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY,

 * NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.

 */



namespace AcquireHoKTokenBySolutionCertificateSample

{

    using System;

    using System.Net;

    using System.Security.Cryptography.X509Certificates;

    using System.Xml;

    using VMware.Binding.WsTrust;

    using vmware.sso;



    public class AcquireHoKTokenBySolutionCertificate

    {

        # region private function Definition



        /// <summary>

        ///  This method is used to print message if there is insufficient parameter 

        /// </summary>

        private static void PrintUsage()

        {

            Console.WriteLine("AcquireHoKTokenBySolutionCertificateSample [sso url] [path to pfx file] [private key password]");

        }



        # endregion



        # region public function Definition

        /// <summary>

        ///  This method is used to get Token 

        /// </summary>

        /// <param name="args">string args [sso url] [path to pfx file that includes the private key] [private key password]</param>

        /// <example>AcquireHoKTokenBySolutionCertificateSample [sso server url] rui.pfx mypassword</example>

        /// <remarks>pfx stands for personal exchange format and is used to exchange public 

        /// as well as public and private objects in a single file</remarks>

        public static XmlElement GetToken(String[] args)

        {



            var ssoUrl = args[0];



            // Load the certificate into an X509Certificate object.

            X509Certificate2 cert = null;

            if (args.Length == 3)

            {

                cert = new X509Certificate2(args[1], args[2]);

            }

            else

            {

                cert = new X509Certificate2(args[1], "");

            }



            ServicePointManager.SecurityProtocol |= SecurityProtocolType.Tls12;

            SamlTokenHelper.SetupServerCertificateValidation();



            STSService_PortTypeClient service = SamlTokenHelper.GetSTSService(ssoUrl, null, null, cert);

            RequestSecurityTokenType tokenType = SamlTokenHelper.GetHokRequestSecurityTokenType();



            try

            {

                RequestSecurityTokenResponseCollectionType responseToken =

                    service.Issue(tokenType);

                RequestSecurityTokenResponseType rstResponse =

                    responseToken.RequestSecurityTokenResponse;



                return rstResponse.RequestedSecurityToken;

            }

            catch (Exception ex)

            {

                Console.WriteLine(ex.ToString());

                throw ex;

            }

        }





        /// <summary>

        /// Main function of the application

        /// </summary>

        /// <param name="args">string args [sso url] [path to pfx file that includes the private key] [private key password]</param>

        /// <example>AcquireHoKTokenBySolutionCertificateSample [sso server url] rui.pfx mypassword</example>

        /// <remarks>pfx stands for personal exchange format and is used to exchange public 

        /// as well as public and private objects in a single file</remarks>

        public static void Main(string[] args)

        {

            if (args.Length < 2)

            {

                PrintUsage();

            }

            else

            {

                SamlTokenHelper.PrintToken(GetToken(args));

            }



            Console.WriteLine("Press Any Key To Exit.");

            Console.ReadLine();

        }



        # endregion

    }

}

