/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.apputils;

import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Headers;
import com.sun.xml.internal.ws.developer.WSBindingProvider;
import com.vmware.vim.sms.SmsPortType;
import com.vmware.vim.sms.SmsService;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

public class SmServiceConnection {
    private final ManagedObjectReference VIM_SVC_INST_REF = new ManagedObjectReference();
    private final ManagedObjectReference SMS_SVC_INST_REF = new ManagedObjectReference();
    private final String VIM_SVC_INST_NAME = "ServiceInstance";
    private final String SMS_SVC_INST_NAME = "ServiceInstance";
    private final String SMS_SVC_INST_TYPE = "SmsServiceInstance";
    private VimService vimService;
    private VimPortType vimPort;
    private SmsService smsService;
    private SmsPortType smsPort;
    private ServiceContent vimServiceContent;
    private String vimHost;
    private String userName;
    private String password;
    private String sessionCookie;

    private void initSvcInstRef() {
        this.VIM_SVC_INST_REF.setType("ServiceInstance");
        this.VIM_SVC_INST_REF.setValue("ServiceInstance");
        this.SMS_SVC_INST_REF.setType("SmsServiceInstance");
        this.SMS_SVC_INST_REF.setValue("ServiceInstance");
    }

    private void initVimPort(String string) throws Exception {
        this.vimService = new VimService();
        this.vimPort = this.vimService.getVimPort();
        Map map = ((BindingProvider)this.vimPort).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", string);
        map.put("javax.xml.ws.session.maintain", true);
    }

    private void initSmsPort(String string) throws Exception {
        String string2 = string.replace("/sdk", "/sms/sdk");
        this.smsService = new SmsService();
        this.smsPort = this.smsService.getSmsPort();
        Map map = ((BindingProvider)this.smsPort).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", string2);
        map.put("javax.xml.ws.session.maintain", true);
        WSBindingProvider wSBindingProvider = (WSBindingProvider)this.smsPort;
        wSBindingProvider.setOutboundHeaders(new Header[]{Headers.create((QName)new QName("vcSessionCookie"), (String)this.sessionCookie)});
    }

    private void initAll() throws Exception {
        this.initSvcInstRef();
        this.initVimPort(this.vimHost);
        this.initVimServiceContent();
        this.connect(this.vimHost, this.userName, this.password);
        this.readSessionCookieFromHeaders();
        this.initSmsPort(this.vimHost);
    }

    private void initVimServiceContent() throws Exception {
        if (this.vimServiceContent == null) {
            this.vimServiceContent = this.vimPort.retrieveServiceContent(this.VIM_SVC_INST_REF);
            if (this.vimServiceContent == null) {
                throw new Exception("Could not get Service Content");
            }
        }
    }

    private void readSessionCookieFromHeaders() {
        Map map = ((BindingProvider)this.vimPort).getResponseContext();
        Map map2 = (Map)map.get("javax.xml.ws.http.response.headers");
        if (map2 == null) {
            System.out.println("WARNING: Failed to read HTTP headers for connection");
            return;
        }
        List list = (List)map2.get("Set-cookie");
        if (list == null) {
            System.out.println("WARNING: Failed to read cookie header for connection");
            return;
        }
        String string = (String)list.get(0);
        String[] stringArray = string.split(";");
        stringArray = stringArray[0].split("=");
        this.sessionCookie = stringArray[1];
    }

    private void connect(String string, String string2, String string3) throws Exception {
        this.vimPort.login(this.vimServiceContent.getSessionManager(), string2, string3, null);
    }

    private void disconnect() throws Exception {
        this.vimPort.logout(this.vimServiceContent.getSessionManager());
    }

    private void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustManagerArray = new TrustManager[1];
        TrustAllTrustManager trustAllTrustManager = new TrustAllTrustManager();
        trustManagerArray[0] = trustAllTrustManager;
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        SSLSessionContext sSLSessionContext = sSLContext.getServerSessionContext();
        sSLSessionContext.setSessionTimeout(0);
        sSLContext.init(null, trustManagerArray, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
    }

    public SmServiceConnection(String string, String string2, String string3) throws Exception {
        this.vimHost = string;
        this.userName = string2;
        this.password = string3;
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        this.trustAllHttpsCertificates();
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        this.initAll();
    }

    public VimPortType getVimPort() {
        return this.vimPort;
    }

    public SmsPortType getSmsPort() {
        return this.smsPort;
    }

    public ServiceContent getVimServiceContent() {
        return this.vimServiceContent;
    }

    private static class TrustAllTrustManager
    implements TrustManager,
    X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }
}

