/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmProfile;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.List;

@Sample(name="listprofiles", description="Lists the storage profiles and their basic information")
public class ListProfiles
extends ConnectedServiceBase {
    @Action
    public void listProfiles() throws RuntimeFaultFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, InvalidArgumentFaultMsg {
        List list = this.connection.getPbmPort().pbmQueryProfile(this.connection.getPbmServiceContent().getProfileManager(), PbmUtil.getStorageResourceType(), null);
        System.out.println("No. of storage profiles are " + list.size());
        if (!list.isEmpty()) {
            List list2 = this.connection.getPbmPort().pbmRetrieveContent(this.connection.getPbmServiceContent().getProfileManager(), list);
            for (PbmProfile pbmProfile : list2) {
                System.out.println("------------");
                System.out.println("Profile Name: " + pbmProfile.getName());
                System.out.println("Profile Id: " + pbmProfile.getProfileId().getUniqueId());
                System.out.println("Description: " + pbmProfile.getDescription());
                System.out.println("Created by: " + pbmProfile.getCreatedBy());
                System.out.println("Created at: " + pbmProfile.getCreationTime());
            }
        }
    }
}

