/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityConstraintInstance;
import com.vmware.pbm.PbmCapabilityConstraints;
import com.vmware.pbm.PbmCapabilityDescription;
import com.vmware.pbm.PbmCapabilityDiscreteSet;
import com.vmware.pbm.PbmCapabilityInstance;
import com.vmware.pbm.PbmCapabilityMetadata;
import com.vmware.pbm.PbmCapabilityProfile;
import com.vmware.pbm.PbmCapabilityProfileUpdateSpec;
import com.vmware.pbm.PbmCapabilityPropertyInstance;
import com.vmware.pbm.PbmCapabilityPropertyMetadata;
import com.vmware.pbm.PbmCapabilitySubProfile;
import com.vmware.pbm.PbmCapabilitySubProfileConstraints;
import com.vmware.pbm.PbmDuplicateNameFaultMsg;
import com.vmware.pbm.PbmFaultProfileStorageFaultFaultMsg;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.spbm.connection.helpers.PbmUtil;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.List;

@Sample(name="editprofile", description="Updates a storage profile. Adds a new rule based on tags.")
public class EditProfile
extends ConnectedServiceBase {
    private Boolean addRuleSet = false;
    private Boolean delRuleSet = false;
    private String tagCategoryName;
    private String profileName;
    private String ruleSetName;
    private PbmServiceInstanceContent spbmsc;
    private PbmCapabilityProfile profile;

    @Action
    public void editProfile() throws RuntimeFaultFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg, InvalidArgumentFaultMsg, PbmDuplicateNameFaultMsg, PbmFaultProfileStorageFaultFaultMsg {
        PbmCapabilityPropertyMetadata pbmCapabilityPropertyMetadata;
        Object object;
        PbmCapabilityMetadata pbmCapabilityMetadata;
        Object object22;
        if (!this.addRuleSet.booleanValue() && !this.delRuleSet.booleanValue()) {
            throw new InvalidArgumentFaultMsg("Either of add or delete argument is required.", null);
        }
        this.spbmsc = this.connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = this.spbmsc.getProfileManager();
        List list = this.connection.getPbmPort().pbmFetchCapabilityMetadata(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        List list2 = this.connection.getPbmPort().pbmQueryProfile(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        if (list2 == null || list2.isEmpty()) {
            throw new RuntimeFaultFaultMsg("No storage Profiles exist.", null);
        }
        List list3 = this.connection.getPbmPort().pbmRetrieveContent(managedObjectReference, list2);
        for (Object object22 : list3) {
            if (!object22.getName().equals(this.profileName)) continue;
            this.profile = (PbmCapabilityProfile)object22;
        }
        if (this.profile == null) {
            throw new InvalidArgumentFaultMsg("Specified storage profile name does not exist.", null);
        }
        PbmCapabilitySubProfileConstraints pbmCapabilitySubProfileConstraints = (PbmCapabilitySubProfileConstraints)this.profile.getConstraints();
        object22 = pbmCapabilitySubProfileConstraints.getSubProfiles();
        if (this.addRuleSet.booleanValue()) {
            Object object32;
            if (this.tagCategoryName == null) {
                throw new InvalidArgumentFaultMsg("Missing tag_category option with add", null);
            }
            pbmCapabilityMetadata = PbmUtil.getTagCategoryMeta(this.tagCategoryName, list);
            if (pbmCapabilityMetadata == null) {
                throw new InvalidArgumentFaultMsg("Specified Tag Category '" + this.tagCategoryName + "' does not exist", null);
            }
            object = pbmCapabilityMetadata.getPropertyMetadata();
            pbmCapabilityPropertyMetadata = (PbmCapabilityPropertyMetadata)object.get(0);
            PbmCapabilityPropertyInstance pbmCapabilityPropertyInstance = new PbmCapabilityPropertyInstance();
            pbmCapabilityPropertyInstance.setId(pbmCapabilityPropertyMetadata.getId());
            PbmCapabilityDiscreteSet pbmCapabilityDiscreteSet = (PbmCapabilityDiscreteSet)pbmCapabilityPropertyMetadata.getAllowedValue();
            if (pbmCapabilityDiscreteSet == null || pbmCapabilityDiscreteSet.getValues().isEmpty()) {
                throw new RuntimeFaultFaultMsg("Specified Tag Category does not have any associated tags", null);
            }
            PbmCapabilityDiscreteSet pbmCapabilityDiscreteSet2 = new PbmCapabilityDiscreteSet();
            for (Object object32 : pbmCapabilityDiscreteSet.getValues()) {
                pbmCapabilityDiscreteSet2.getValues().add(((PbmCapabilityDescription)object32).getValue());
            }
            pbmCapabilityPropertyInstance.setValue((Object)pbmCapabilityDiscreteSet2);
            PbmCapabilityConstraintInstance pbmCapabilityConstraintInstance = new PbmCapabilityConstraintInstance();
            pbmCapabilityConstraintInstance.getPropertyInstance().add(pbmCapabilityPropertyInstance);
            object32 = new PbmCapabilityInstance();
            object32.setId(pbmCapabilityMetadata.getId());
            object32.getConstraint().add(pbmCapabilityConstraintInstance);
            PbmCapabilitySubProfile pbmCapabilitySubProfile = new PbmCapabilitySubProfile();
            pbmCapabilitySubProfile.setName("Rule-Set " + (object22.size() + 1));
            pbmCapabilitySubProfile.getCapability().add(object32);
            object22.add(pbmCapabilitySubProfile);
        }
        if (this.delRuleSet.booleanValue()) {
            if (this.ruleSetName == null) {
                throw new InvalidArgumentFaultMsg("Missing ruleset_name option with delete", null);
            }
            pbmCapabilityMetadata = null;
            object = object22.iterator();
            while (object.hasNext()) {
                pbmCapabilityPropertyMetadata = (PbmCapabilitySubProfile)object.next();
                if (!pbmCapabilityPropertyMetadata.getName().equals(this.ruleSetName)) continue;
                pbmCapabilityMetadata = pbmCapabilityPropertyMetadata;
            }
            if (pbmCapabilityMetadata == null) {
                throw new RuntimeFaultFaultMsg("Specified Rule-Set name " + this.ruleSetName + " does not exist", null);
            }
            if (object22.size() == 1) {
                throw new RuntimeFaultFaultMsg("Cannot delete the ruleset. At least one ruleset is required for a profile.", null);
            }
            object22.remove(pbmCapabilityMetadata);
        }
        pbmCapabilityMetadata = new PbmCapabilityProfileUpdateSpec();
        pbmCapabilityMetadata.setName(this.profileName);
        pbmCapabilityMetadata.setDescription("Tag Based Storage Profile Created by SDK Samples. Rule based on tags from Category " + this.tagCategoryName);
        pbmCapabilityMetadata.setConstraints((PbmCapabilityConstraints)pbmCapabilitySubProfileConstraints);
        this.connection.getPbmPort().pbmUpdate(managedObjectReference, this.profile.getProfileId(), (PbmCapabilityProfileUpdateSpec)pbmCapabilityMetadata);
        System.out.println("Profile " + this.profileName + " Updated.");
    }

    @Option(name="add", description="Flag to denote addition of a rule set. Requires tag_category property to be specified.", parameter=false, required=false)
    public void setAddRuleSetName(Boolean bl) {
        this.addRuleSet = bl;
    }

    @Option(name="delete", description="Flag to denote deletion of a rule set. Requires ruleset_name property to be specified.", parameter=false, required=false)
    public void setDelRuleSetName(Boolean bl) {
        this.delRuleSet = bl;
    }

    @Option(name="profilename", description="Name of an existing storage profile", required=true)
    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Option(name="ruleset_name", description="Name of the rule-set to be deleted.", required=false)
    public void setRuleSetName(String string) {
        this.ruleSetName = string;
    }

    @Option(name="tag_category", description="Category Name of the tags. All tags in this category are added to the rule.", required=false)
    public void setTagCategoryName(String string) {
        this.tagCategoryName = string;
    }
}

