/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.connection;

import com.vmware.common.annotations.After;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.pbm.PbmPortType;
import com.vmware.pbm.PbmService;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.net.URL;

public interface Connection {
    @Before
    public Connection connect();

    @After
    public Connection disconnect();

    public String getPassword();

    public PbmPortType getPbmPort();

    public PbmService getPbmService();

    public PbmServiceInstanceContent getPbmServiceContent();

    public ManagedObjectReference getPbmServiceInstanceReference();

    public URL getSpbmURL();

    public URL getSsoURL();

    public String getUsername();

    public UserSession getUserSession();

    public URL getVcURL();

    public VimPortType getVimPort();

    public VimService getVimService();

    public ServiceContent getVimServiceContent();

    public ManagedObjectReference getVimServiceInstanceReference();

    public boolean isConnected();

    @Option(name="ignorecert", systemProperty="ssl.trustAll.enabled", description="Ignore the SSL certificate check", parameter=false, required=false)
    public void setIgnoreCert(Boolean var1);

    @Option(name="password", systemProperty="connection.password", description="password on remote system")
    public void setPassword(String var1);

    @Option(name="spbmurl", systemProperty="spbmService.url", description="full url to the SPBM service on vCenter", required=false)
    public void setSpbmUrl(String var1);

    @Option(name="ssourl", systemProperty="sso.url", description="full url to the STS service", required=false)
    public void setSsoUrl(String var1);

    @Option(name="username", systemProperty="connection.username", description="username on remote system")
    public void setUsername(String var1);

    @Option(name="vcurl", systemProperty="vimService.url", description="full url to the vSphere WS SDK service on vCenter")
    public void setVcUrl(String var1);
}

