/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.ua;

import java.net.InetAddress;
import java.util.Locale;
import java.util.SortedSet;
import java.util.Vector;
import org.sblim.slp.Locator;
import org.sblim.slp.ServiceLocationEnumeration;
import org.sblim.slp.ServiceType;
import org.sblim.slp.ServiceURL;
import org.sblim.slp.internal.TRC;
import org.sblim.slp.internal.msg.AttributeRequest;
import org.sblim.slp.internal.msg.ServiceRequest;
import org.sblim.slp.internal.msg.ServiceTypeRequest;
import org.sblim.slp.internal.msg.Util;
import org.sblim.slp.internal.ua.SLEnumerationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatorImpl
implements Locator {
    private Locale iLocale;
    private String iLangTag;

    public LocatorImpl(Locale pLocale) {
        this.iLocale = pLocale;
        this.iLangTag = Util.getLangTag(this.iLocale);
        TRC.debug("created, langTag=" + this.iLangTag);
    }

    @Override
    public ServiceLocationEnumeration findAttributes(ServiceURL pURL, Vector<String> pScopes, Vector<String> pAttributeIds) {
        return this.findAttributes(pURL, pScopes, pAttributeIds, null);
    }

    @Override
    public ServiceLocationEnumeration findAttributes(ServiceURL pURL, Vector<String> pScopes, Vector<String> pAttributeIds, Vector<InetAddress> pDirectoryAgents) {
        return new SLEnumerationImpl(new AttributeRequest(this.iLangTag, (SortedSet<String>)null, pURL.toString(), LocatorImpl.getScopes(pScopes), pAttributeIds, null), pDirectoryAgents);
    }

    @Override
    public ServiceLocationEnumeration findAttributes(ServiceType pType, Vector<String> pScopes, Vector<String> pAttributeIds) {
        return this.findAttributes(pType, pScopes, pAttributeIds, null);
    }

    @Override
    public ServiceLocationEnumeration findAttributes(ServiceType pType, Vector<String> pScopes, Vector<String> pAttributeIds, Vector<InetAddress> pDirectoryAgents) {
        return new SLEnumerationImpl(new AttributeRequest(this.iLangTag, (SortedSet<String>)null, pType.toString(), LocatorImpl.getScopes(pScopes), pAttributeIds, null), pDirectoryAgents);
    }

    @Override
    public ServiceLocationEnumeration findServiceTypes(String pNamingAuthority, Vector<String> pScopes) {
        return this.findServiceTypes(pNamingAuthority, pScopes, null);
    }

    @Override
    public ServiceLocationEnumeration findServiceTypes(String pNamingAuthority, Vector<String> pScopes, Vector<InetAddress> pDirectoryAgent) {
        return new SLEnumerationImpl(new ServiceTypeRequest(this.iLangTag, null, pNamingAuthority, LocatorImpl.getScopes(pScopes)), pDirectoryAgent);
    }

    @Override
    public ServiceLocationEnumeration findServices(ServiceType pType, Vector<String> pScopes, String pSearchFilter) {
        return this.findServices(pType, pScopes, pSearchFilter, null);
    }

    @Override
    public ServiceLocationEnumeration findServices(ServiceType pType, Vector<String> pScopes, String pSearchFilter, Vector<InetAddress> pDirectoryAgents) {
        return new SLEnumerationImpl(new ServiceRequest(this.iLangTag, null, pType, LocatorImpl.getScopes(pScopes), pSearchFilter, null), pDirectoryAgents);
    }

    @Override
    public Locale getLocale() {
        return this.iLocale;
    }

    private static Vector<String> getScopes(Vector<String> pScopes) {
        if (pScopes == null) {
            pScopes = new Vector();
        }
        if (pScopes.isEmpty()) {
            pScopes.add("default");
        }
        return pScopes;
    }
}

