/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.sblim.slp.Advertiser;
import org.sblim.slp.ServiceLocationAttribute;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.ServiceURL;
import org.sblim.slp.internal.Net;
import org.sblim.slp.internal.SLPConfig;
import org.sblim.slp.internal.TRC;
import org.sblim.slp.internal.msg.MsgFactory;
import org.sblim.slp.internal.msg.SLPMessage;
import org.sblim.slp.internal.msg.ServiceAcknowledgment;
import org.sblim.slp.internal.msg.ServiceDeregistration;
import org.sblim.slp.internal.msg.ServiceRegistration;
import org.sblim.slp.internal.msg.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertiserImpl
implements Advertiser {
    private Locale iLocale;
    private String iLangTag;
    private List<String> iDefScopeList;
    private final int iMaxDatagramSize = SLPConfig.getGlobalCfg().getMTU();
    private final byte[] iInBuf = new byte[this.iMaxDatagramSize];
    private final int[] iTimeOuts = SLPConfig.getGlobalCfg().getDatagramTimeouts();
    private boolean iUseV6 = Net.hasIPv6() && SLPConfig.getGlobalCfg().useIPv6();

    public AdvertiserImpl(Locale pLocale) {
        this.iLocale = pLocale;
        this.iLangTag = Util.getLangTag(this.iLocale);
        this.iDefScopeList = new ArrayList<String>();
        this.iDefScopeList.add("default");
    }

    @Override
    public void addAttributes(ServiceURL pURL, Vector<ServiceLocationAttribute> pAttributes) throws ServiceLocationException {
        throw new ServiceLocationException(16);
    }

    @Override
    public void deleteAttributes(ServiceURL pURL, Vector<String> pAttributeIds) throws ServiceLocationException {
        throw new ServiceLocationException(16);
    }

    @Override
    public void deregister(ServiceURL pURL) throws ServiceLocationException {
        this.sendMessage(new ServiceDeregistration(this.iLangTag, this.iDefScopeList, pURL, null));
    }

    @Override
    public Locale getLocale() {
        return this.iLocale;
    }

    @Override
    public void register(ServiceURL pURL, Vector<ServiceLocationAttribute> pAttributes) throws ServiceLocationException {
        this.sendMessage(new ServiceRegistration(this.iLangTag, pURL, this.iDefScopeList, pAttributes, null));
    }

    private void sendMessage(SLPMessage pMsg) throws ServiceLocationException {
        try {
            int res = this.unicast(pMsg);
            if (res != 0) {
                throw new ServiceLocationException((short)res);
            }
            TRC.debug("service registered");
        }
        catch (IOException e) {
            throw new ServiceLocationException(19, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unicast(SLPMessage pMsg) throws ServiceLocationException, IOException {
        DatagramSocket dgSocket = new DatagramSocket();
        try {
            byte[] reqBytes = pMsg.serialize(false, true, false);
            InetAddress loopback = this.iUseV6 ? SLPConfig.getLoopbackV6() : SLPConfig.getLoopbackV4();
            TRC.debug("loopback:" + loopback);
            DatagramPacket outPacket = new DatagramPacket(reqBytes, reqBytes.length, loopback, SLPConfig.getGlobalCfg().getPort());
            DatagramPacket inPacket = new DatagramPacket(this.iInBuf, this.iInBuf.length);
            int timeOutIdx = 0;
            while (timeOutIdx < this.iTimeOuts.length) {
                ServiceAcknowledgment ack;
                TRC.debug("sending : " + pMsg);
                dgSocket.send(outPacket);
                dgSocket.setSoTimeout(this.iTimeOuts[timeOutIdx++]);
                try {
                    dgSocket.receive(inPacket);
                }
                catch (SocketTimeoutException e) {
                    TRC.debug("receive time out");
                    continue;
                }
                SLPMessage msg = MsgFactory.parse(inPacket);
                TRC.debug("expected: " + pMsg.getXID() + ", received : " + msg);
                if (msg instanceof ServiceAcknowledgment && (ack = (ServiceAcknowledgment)msg).getXID() == pMsg.getXID()) {
                    int n = ack.getErrorCode();
                    return n;
                }
                TRC.debug("ignoring :" + msg);
            }
        }
        finally {
            dgSocket.close();
        }
        TRC.warning("registration failed");
        return 3;
    }
}

