/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.wbem;

import java.io.IOException;
import java.io.InputStreamReader;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.cimclient.internal.cimxml.sax.XMLDefaultHandlerImpl;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractMessageNode;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractSimpleRspNode;
import org.sblim.cimclient.internal.cimxml.sax.node.CIMNode;
import org.sblim.cimclient.internal.cimxml.sax.node.MessageNode;
import org.sblim.cimclient.internal.http.io.TrailerException;
import org.sblim.cimclient.internal.wbem.CIMError;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableIteratorSAX
implements CloseableIterator<Object> {
    private AbstractSimpleRspNode iAbsSimpleRspNode;
    private CIMError iErr;
    private WBEMException iWBEMException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteratorSAX(InputStreamReader pStream, CIMObjectPath pPath) throws IOException, SAXException, ParserConfigurationException, WBEMException {
        XMLDefaultHandlerImpl handler = new XMLDefaultHandlerImpl(pPath);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        try {
            saxParser.parse(new InputSource(pStream), (DefaultHandler)handler);
        }
        catch (TrailerException e) {
            this.iWBEMException = e.getWBEMException();
            return;
        }
        finally {
            pStream.close();
        }
        this.init(handler.getCIMNode());
    }

    public CloseableIteratorSAX(CIMNode pCIMNode) throws WBEMException {
        this.init(pCIMNode);
    }

    private void init(CIMNode pCIMNode) throws WBEMException {
        MessageNode msgNode = pCIMNode.getMessageNode();
        if (msgNode == null) {
            throw new WBEMException("CIMNode parameter must contain a message node!");
        }
        AbstractMessageNode absMsgNode = msgNode.getAbstractMessageNode();
        if (!(absMsgNode instanceof AbstractSimpleRspNode)) {
            throw new WBEMException("Currently only AbstractSimpleRspNodes are handled!");
        }
        this.iAbsSimpleRspNode = (AbstractSimpleRspNode)absMsgNode;
        this.iErr = this.iAbsSimpleRspNode.getCIMError();
    }

    @Override
    public void close() {
        this.iAbsSimpleRspNode = null;
        this.iErr = null;
        this.iWBEMException = null;
    }

    @Override
    public boolean hasNext() {
        if (this.iWBEMException != null) {
            throw new RuntimeException(this.iWBEMException);
        }
        if (this.iErr != null) {
            this.iWBEMException = new WBEMException(this.iErr.getCode(), this.iErr.getDescription(), this.iErr.getCIMInstances());
            throw new RuntimeException(this.iWBEMException);
        }
        return this.iAbsSimpleRspNode == null ? false : this.iAbsSimpleRspNode.getReturnValueCount() > 0;
    }

    @Override
    public Object next() {
        return this.iAbsSimpleRspNode.readReturnValue();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WBEMException getWBEMException() {
        return this.iWBEMException;
    }
}

