/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.uri;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sblim.cimclient.internal.uri.URIString;
import org.sblim.cimclient.internal.uri.Value;

public class RealValue
extends Value {
    private double iValue;
    private boolean iDoublePrec;
    private static final Pattern WHITE_PAT = Pattern.compile("^.*[\\s\\n]+.*$");

    private static Value parse(URIString pUriStr, boolean pDoublePrec, boolean pThrow) throws IllegalArgumentException {
        URIString uriStr = pUriStr.deepCopy();
        String strVal = uriStr.removeTill(',');
        if (strVal == null) {
            if (pThrow) {
                String msg = "Empty real value!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        Matcher m = WHITE_PAT.matcher(strVal);
        if (m.matches()) {
            if (pThrow) {
                String msg = "Illegal real format!\n" + pUriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        try {
            double val = Double.parseDouble(strVal);
            pUriStr.set(uriStr);
            return new RealValue(val, pDoublePrec);
        }
        catch (NumberFormatException e) {
            if (pThrow) {
                String msg = "Illegal number format!\n" + pUriStr.markPosition() + "Nested message:\n" + e.getMessage();
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
    }

    public static Value parse(URIString pUriStr) {
        return RealValue.parse(pUriStr, true, false);
    }

    public static Value parseFloat(URIString pUriStr) throws IllegalArgumentException {
        return RealValue.parse(pUriStr, false, true);
    }

    public static Value parseDouble(URIString pUriStr) throws IllegalArgumentException {
        return RealValue.parse(pUriStr, true, true);
    }

    private RealValue(double pValue, boolean pDoublePrec) {
        this.iValue = pValue;
        this.iDoublePrec = pDoublePrec;
    }

    public boolean isDouble() {
        return this.iDoublePrec;
    }

    public float floatValue() {
        return (float)this.iValue;
    }

    public double doubleValue() {
        return this.iValue;
    }

    public String toString() {
        return Double.toString(this.iValue);
    }

    public String getTypeInfo() {
        if (this.iDoublePrec) {
            return "real64";
        }
        return "real32";
    }
}

