/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.uri;

import java.util.regex.Pattern;
import org.sblim.cimclient.internal.uri.URIString;

public class Authority {
    private static final String PCTENCODED = "%[0-9A-Fa-f]{2}";
    private static final String UNRESERVED = "A-Za-z0-9\\-\\._~";
    private static final String SUBDELIMS = "!\\$&'\\(\\)\\*\\+,;=";
    private static final String REGNAMEREG = "([A-Za-z0-9\\-\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9A-Fa-f]{2})+";
    private static final String IPV4 = "([0-9]{1,3}\\.){3}[0-9]{1,3}";
    private static final String H16 = "[0-9A-Fa-f]{1,4}";
    private static final String LS32 = "(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3}))";
    private static final String IPV6 = "(([0-9A-Fa-f]{1,4}:){6}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|(::([0-9A-Fa-f]{1,4}:){5}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|(([0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){4}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){3}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){2}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4})|((([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::)";
    private static final String IPVFUTURE = "v[0-9A-Fa-f]+\\.([A-Za-z0-9\\-\\._~!\\$&'\\(\\)\\*\\+,;=]|:)+";
    private static final String IPLITERAL = "\\[((([0-9A-Fa-f]{1,4}:){6}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|(::([0-9A-Fa-f]{1,4}:){5}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|(([0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){4}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){3}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){2}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4})|((([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::)|v[0-9A-Fa-f]+\\.([A-Za-z0-9\\-\\._~!\\$&'\\(\\)\\*\\+,;=]|:)+)\\]";
    private static Pattern USERINFOPAT = Pattern.compile("^((([A-Za-z0-9\\-\\._~!\\$&'\\(\\)\\*\\+,;=:]|(%[0-9A-Fa-f]{2}))*)@).*");
    private static Pattern HOSTPAT = Pattern.compile("^((([0-9]{1,3}\\.){3}[0-9]{1,3})|(([A-Za-z0-9\\-\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9A-Fa-f]{2})+)|(\\[((([0-9A-Fa-f]{1,4}:){6}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|(::([0-9A-Fa-f]{1,4}:){5}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|(([0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){4}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){3}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){2}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3})))|((([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4})|((([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::)|v[0-9A-Fa-f]+\\.([A-Za-z0-9\\-\\._~!\\$&'\\(\\)\\*\\+,;=]|:)+)\\])).*");
    private static Pattern PORTPAT = Pattern.compile("^([0-9]+).*");
    private String iUserInfo;
    private String iHost;
    private String iPort;

    public static Authority parse(URIString pUriStr) {
        URIString uriStr = pUriStr.deepCopy();
        String userInfo = uriStr.matchAndCut(USERINFOPAT, 1) ? uriStr.group(2) : null;
        if (!uriStr.matchAndCut(HOSTPAT, 1)) {
            return null;
        }
        String host = uriStr.group(1);
        String port = null;
        if (uriStr.cutStarting(':')) {
            if (!uriStr.matchAndCut(PORTPAT, 1)) {
                return null;
            }
            port = uriStr.group(1);
        }
        pUriStr.set(uriStr);
        return new Authority(userInfo, host, port);
    }

    private Authority(String pUserInfo, String pHost, String pPort) {
        this.iUserInfo = pUserInfo;
        this.iHost = pHost;
        this.iPort = pPort;
    }

    public String toString() {
        return (this.iUserInfo == null ? "" : this.iUserInfo + "@") + this.iHost + (this.iPort == null ? "" : ":" + this.iPort);
    }

    public String getUserInfo() {
        return this.iUserInfo;
    }

    public String getHost() {
        return this.iHost;
    }

    public String getPort() {
        return this.iPort;
    }
}

