/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ClusterAction;
import com.vmware.vim25.ClusterRecommendation;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFaultFaultMsg;
import com.vmware.vim25.PlacementAction;
import com.vmware.vim25.PlacementResult;
import com.vmware.vim25.PlacementSpec;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TimedoutFaultMsg;
import com.vmware.vim25.VirtualMachineMovePriority;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.List;
import java.util.Map;

@Sample(name="xvmotion", description="This sample is used to migrate/relocate VM to another host and datastoreusing the drs placement recommendations")
public class XVMotion
extends ConnectedVimServiceBase {
    String vmName = null;
    String destCluster = null;

    @Option(name="vmname", description="Name of the virtual machine to be migrated")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="clustername", description="Target cluster name")
    public void setCluster(String string) {
        this.destCluster = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    @Action
    public void placeVM() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, MigrationFaultFaultMsg, TimedoutFaultMsg, VmConfigFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        PlacementSpec placementSpec = new PlacementSpec();
        ManagedObjectReference managedObjectReference = null;
        ManagedObjectReference managedObjectReference2 = null;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "ClusterComputeResource");
        if (!map.containsKey(this.destCluster)) {
            throw new IllegalStateException("No Cluster by the name of '" + this.destCluster + "' found!");
        }
        managedObjectReference2 = map.get(this.destCluster);
        Map<String, ManagedObjectReference> map2 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        if (!map2.containsKey(this.vmName)) {
            throw new IllegalStateException("No VM by the name of '" + this.vmName + "' found!");
        }
        managedObjectReference = map2.get(this.vmName);
        placementSpec.setVm(managedObjectReference);
        PlacementResult placementResult = this.vimPort.placeVm(managedObjectReference2, placementSpec);
        PlacementAction placementAction = this.getPlacementAction(placementResult);
        if (placementAction != null) {
            VirtualMachineRelocateSpec virtualMachineRelocateSpec = placementAction.getRelocateSpec();
            ManagedObjectReference managedObjectReference3 = this.vimPort.relocateVMTask(managedObjectReference, virtualMachineRelocateSpec, VirtualMachineMovePriority.DEFAULT_PRIORITY);
            if (this.getTaskResultAfterDone(managedObjectReference3)) {
                System.out.println("Relocation done successfully");
            } else {
                System.out.println("Error::  Relocation failed");
            }
        } else {
            System.out.println("Recommendations are not correct");
        }
    }

    PlacementAction getPlacementAction(PlacementResult placementResult) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List list = placementResult.getRecommendations();
        PlacementAction placementAction = null;
        int n = list.size();
        boolean bl = false;
        if (n > 0) {
            System.out.println("Total number of recommendations are " + n);
            System.out.println("Processing the xvmotion placement recommendations out of the recommendations received");
            for (ClusterRecommendation clusterRecommendation : list) {
                if (!clusterRecommendation.getReason().equalsIgnoreCase("xvmotionPlacement")) continue;
                List list2 = clusterRecommendation.getAction();
                for (ClusterAction clusterAction : list2) {
                    if (!(clusterAction instanceof PlacementAction)) continue;
                    placementAction = (PlacementAction)clusterAction;
                    break;
                }
                if (placementAction != null) {
                    if (placementAction.getVm() == null || placementAction.getTargetHost() == null) {
                        System.out.println("Placement Action doesnot have a vm and targethost set");
                        continue;
                    }
                    if (placementAction.getRelocateSpec() == null) continue;
                    bl = this.checkRelocateSpec(placementAction.getRelocateSpec());
                    if (!bl) {
                        placementAction = null;
                        continue;
                    }
                    break;
                }
                System.out.println("Recommendation doesnot have a placement action");
            }
        } else {
            System.out.println("No recommendations by DRS");
        }
        return placementAction;
    }

    boolean checkRelocateSpec(VirtualMachineRelocateSpec virtualMachineRelocateSpec) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        boolean bl = false;
        if (virtualMachineRelocateSpec.getHost() != null) {
            if (virtualMachineRelocateSpec.getPool() != null) {
                if (virtualMachineRelocateSpec.getDatastore() != null) {
                    bl = true;
                } else {
                    System.out.println("RelocateSpec doesnot have a datastore");
                }
            } else {
                System.out.println("RelocateSpec doesnot have a resource pool");
            }
        } else {
            System.out.println("RelocateSpec doesnot have a host");
        }
        return bl;
    }
}

