/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.ClusterAction;
import com.vmware.vim25.ClusterRecommendation;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFaultFaultMsg;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PlacementAction;
import com.vmware.vim25.PlacementResult;
import com.vmware.vim25.PlacementSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.ResourceAllocationInfo;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.ServiceLocator;
import com.vmware.vim25.ServiceLocatorCredential;
import com.vmware.vim25.ServiceLocatorNamePassword;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TimedoutFaultMsg;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineFileInfo;
import com.vmware.vim25.VirtualMachineMovePriority;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import com.vmware.vm.DestConnect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.soap.SOAPFaultException;

@Sample(name="XVCvMotion", description="Used to Relocate VM from one VC to another")
public class XVCvMotion
extends ConnectedVimServiceBase {
    String vmName = null;
    String destCluster = null;
    String remoteurl = null;
    String ruser = null;
    String rpassword = null;
    String rthumbprint = null;
    String targetFolder = null;
    private static VimPortType destVimPort = null;
    private static ServiceContent destServiceContent = null;

    @Option(name="vmname", description="name of the virtual machine to be migrated")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="clustername", description="Target Cluster Name")
    public void setCluster(String string) {
        this.destCluster = string;
    }

    @Option(name="remoteurl", description="Target vCenter URL ")
    public void setRemoteUrl(String string) {
        this.remoteurl = string;
    }

    @Option(name="ruser", description="Target vCenter username")
    public void setRuser(String string) {
        this.ruser = string;
    }

    @Option(name="rpassword", description="Target vCenter Password")
    public void setRpassword(String string) {
        this.rpassword = string;
    }

    @Option(name="rthumbprint", description="Thumbprint of Target vCenter")
    public void setThumbprint(String string) {
        this.rthumbprint = string;
    }

    @Option(name="targetfolder", description="Target Folder", required=false)
    public void setTargetFolder(String string) {
        this.targetFolder = string;
    }

    ManagedObjectReference getVMFolderMor(ManagedObjectReference managedObjectReference, String string, String string2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List<SelectionSpec> list = this.buildVmFolderTraversal();
        ManagedObjectReference managedObjectReference2 = null;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("name");
        propertySpec.setType(string);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().addAll(list);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list2 = this.retrievePropertiesAllObjects(arrayList);
        if (list2 != null) {
            for (ObjectContent objectContent : list2) {
                ManagedObjectReference managedObjectReference3 = objectContent.getObj();
                String string3 = null;
                List list3 = objectContent.getPropSet();
                DynamicProperty[] dynamicPropertyArray = list3.toArray(new DynamicProperty[list3.size()]);
                if (dynamicPropertyArray != null) {
                    for (DynamicProperty dynamicProperty : dynamicPropertyArray) {
                        string3 = (String)dynamicProperty.getVal();
                    }
                }
                if (string3 == null || !string3.equals(string2)) continue;
                managedObjectReference2 = managedObjectReference3;
                break;
            }
        } else {
            System.out.println("The Object Content is Null");
        }
        return managedObjectReference2;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = destVimPort.retrievePropertiesEx(destServiceContent.getPropertyCollector(), list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = destVimPort.continueRetrievePropertiesEx(destServiceContent.getPropertyCollector(), string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    List<SelectionSpec> buildVmFolderTraversal() {
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setType("Datacenter");
        traversalSpec.setSkip(Boolean.FALSE);
        traversalSpec.setPath("vmFolder");
        traversalSpec.setName("dcToVmf");
        traversalSpec.getSelectSet().add(this.getSelectionSpec("visitFolders"));
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setType("ClusterComputeResource");
        traversalSpec2.setSkip(Boolean.FALSE);
        traversalSpec2.setPath("parent");
        traversalSpec2.setName("cctoparent");
        traversalSpec2.getSelectSet().add(this.getSelectionSpec("foldertoparent"));
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setType("Folder");
        traversalSpec3.setSkip(Boolean.FALSE);
        traversalSpec3.setPath("parent");
        traversalSpec3.setName("foldertoparent");
        traversalSpec3.getSelectSet().add(this.getSelectionSpec("foldertoparent"));
        traversalSpec3.getSelectSet().add(this.getSelectionSpec("dcToVmf"));
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setType("Folder");
        traversalSpec4.setPath("childEntity");
        traversalSpec4.setSkip(Boolean.FALSE);
        traversalSpec4.setName("visitFolders");
        traversalSpec4.getSelectSet().add(this.getSelectionSpec("visitFolders"));
        ArrayList<SelectionSpec> arrayList = new ArrayList<SelectionSpec>();
        arrayList.add((SelectionSpec)traversalSpec4);
        arrayList.add((SelectionSpec)traversalSpec);
        arrayList.add((SelectionSpec)traversalSpec2);
        arrayList.add((SelectionSpec)traversalSpec3);
        return arrayList;
    }

    SelectionSpec getSelectionSpec(String string) {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName(string);
        return selectionSpec;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Action
    public void placeVM() throws DuplicateNameFaultMsg, InvalidNameFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, MigrationFaultFaultMsg, TimedoutFaultMsg, VmConfigFaultFaultMsg, InvalidCollectorVersionFaultMsg, InvalidLocaleFaultMsg, InvalidLoginFaultMsg {
        Object object;
        Object object22;
        ManagedObjectReference managedObjectReference = null;
        PlacementSpec placementSpec = new PlacementSpec();
        ManagedObjectReference managedObjectReference2 = null;
        System.out.println("Searching for VM '" + this.vmName + "'..");
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        if (!map.containsKey(this.vmName)) {
            throw new IllegalStateException("No VM by the name of '" + this.vmName + "' found!");
        }
        System.out.println("Found VM: " + this.vmName);
        managedObjectReference2 = map.get(this.vmName);
        Map<String, Object> map2 = this.getMOREFs.entityProps(managedObjectReference2, new String[]{"config.version", "config.cpuAllocation", "config.memoryAllocation", "config.hardware.numCPU", "config.hardware.memoryMB", "config.files", "config.swapPlacement", "config.hardware.device", "config.name"});
        System.out.println("Setting VirtualMachineConfigSpec properties--");
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        virtualMachineConfigSpec.setVersion((String)map2.get("config.version"));
        virtualMachineConfigSpec.setCpuAllocation((ResourceAllocationInfo)map2.get("config.cpuAllocation"));
        virtualMachineConfigSpec.setMemoryAllocation((ResourceAllocationInfo)map2.get("config.memoryAllocation"));
        virtualMachineConfigSpec.setNumCPUs((Integer)map2.get("config.hardware.numCPU"));
        Integer n = (Integer)map2.get("config.hardware.memoryMB");
        virtualMachineConfigSpec.setMemoryMB(Long.valueOf(n.longValue()));
        virtualMachineConfigSpec.setFiles((VirtualMachineFileInfo)map2.get("config.files"));
        virtualMachineConfigSpec.setSwapPlacement((String)map2.get("config.swapPlacement"));
        virtualMachineConfigSpec.setName((String)map2.get("config.name"));
        List list = ((ArrayOfVirtualDevice)map2.get("config.hardware.device")).getVirtualDevice();
        for (Object object22 : list) {
            object = new VirtualDeviceConfigSpec();
            object.setDevice((VirtualDevice)object22);
            virtualMachineConfigSpec.getDeviceChange().add(object);
        }
        placementSpec.setConfigSpec(virtualMachineConfigSpec);
        System.out.println("Connecting to Destination vCenter - " + this.remoteurl);
        DestConnect destConnect = new DestConnect();
        object22 = destConnect.getDestConnection(this.remoteurl, this.ruser, this.rpassword);
        destVimPort = object22.getVimPort();
        destServiceContent = object22.getServiceContent();
        System.out.println("Looking for the Cluster defined on Destination VC");
        object = destConnect.destGetMOREFs.inContainerByType(destServiceContent.getRootFolder(), "ClusterComputeResource");
        if (!object.containsKey(this.destCluster)) {
            throw new IllegalStateException("No Cluster by the name of '" + this.destCluster + "' found!");
        }
        managedObjectReference = (ManagedObjectReference)object.get(this.destCluster);
        System.out.println("Found Cluster '" + this.destCluster + "'on Destination vCenter!");
        System.out.println("Getting Recommendations from DRS for XVCvMotion--");
        PlacementAction placementAction = new PlacementAction();
        try {
            PlacementResult placementResult = destVimPort.placeVm(managedObjectReference, placementSpec);
            placementAction = this.getPlacementAction(placementResult);
        }
        catch (SOAPFaultException sOAPFaultException) {
            if (!sOAPFaultException.getMessage().contains("vim.fault.InvalidState")) throw new IllegalStateException(sOAPFaultException.getMessage());
            throw new IllegalStateException("Check the Cluster setting and make sure that DRS is enabled");
        }
        if (placementAction != null) {
            ManagedObjectReference managedObjectReference3;
            if (this.targetFolder == null) {
                System.out.println("Target Folder undefined Using Default VM Folder");
                managedObjectReference3 = this.getVMFolderMor(managedObjectReference, "Folder", "vm");
            } else {
                System.out.println("Setting Defined TargetFolder as VMFolder for XVCvMotion");
                managedObjectReference3 = this.getVMFolderMor(managedObjectReference, "Folder", this.targetFolder);
            }
            if (managedObjectReference3 == null) throw new IllegalStateException("No Folder by the name of '" + this.targetFolder + "' found!");
            ServiceLocatorNamePassword serviceLocatorNamePassword = new ServiceLocatorNamePassword();
            serviceLocatorNamePassword.setPassword(this.rpassword);
            serviceLocatorNamePassword.setUsername(this.ruser);
            ServiceLocator serviceLocator = new ServiceLocator();
            serviceLocator.setCredential((ServiceLocatorCredential)serviceLocatorNamePassword);
            serviceLocator.setUrl(this.remoteurl);
            serviceLocator.setInstanceUuid(destServiceContent.getAbout().getInstanceUuid());
            serviceLocator.setSslThumbprint(this.rthumbprint);
            VirtualMachineRelocateSpec virtualMachineRelocateSpec = placementAction.getRelocateSpec();
            virtualMachineRelocateSpec.setService(serviceLocator);
            virtualMachineRelocateSpec.setFolder(managedObjectReference3);
            System.out.println("Relocation in Progress!");
            ManagedObjectReference managedObjectReference4 = this.vimPort.relocateVMTask(managedObjectReference2, virtualMachineRelocateSpec, VirtualMachineMovePriority.DEFAULT_PRIORITY);
            if (this.getTaskResultAfterDone(managedObjectReference4)) {
                System.out.println("Relocation done successfully");
            } else {
                System.out.println("Error::  Relocation failed");
            }
        } else {
            System.out.println("Recommendations are not correct");
        }
        destConnect.disconnect();
    }

    PlacementAction getPlacementAction(PlacementResult placementResult) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List list = placementResult.getRecommendations();
        PlacementAction placementAction = null;
        int n = list.size();
        boolean bl = false;
        if (n > 0) {
            System.out.println("Total number of recommendations are " + n);
            System.out.println("Processing the xvcvmotion placement recommendations out of the recommendations received");
            for (ClusterRecommendation clusterRecommendation : list) {
                if (!clusterRecommendation.getReason().equalsIgnoreCase("xvmotionPlacement")) continue;
                List list2 = clusterRecommendation.getAction();
                for (ClusterAction clusterAction : list2) {
                    if (!(clusterAction instanceof PlacementAction)) continue;
                    placementAction = (PlacementAction)clusterAction;
                    break;
                }
                if (placementAction != null) {
                    if (placementAction.getVm() == null || placementAction.getTargetHost() == null) {
                        System.out.println("Placement Action doesnot have a vm and targethost set");
                        continue;
                    }
                    if (placementAction.getRelocateSpec() == null) continue;
                    bl = this.checkRelocateSpec(placementAction.getRelocateSpec());
                    if (!bl) {
                        placementAction = null;
                        continue;
                    }
                    break;
                }
                System.out.println("Recommendation doesnot have a placement action");
            }
        } else {
            System.out.println("No recommendations by DRS");
        }
        return placementAction;
    }

    boolean checkRelocateSpec(VirtualMachineRelocateSpec virtualMachineRelocateSpec) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        boolean bl = false;
        if (virtualMachineRelocateSpec.getHost() != null) {
            if (virtualMachineRelocateSpec.getPool() != null) {
                if (virtualMachineRelocateSpec.getDatastore() != null) {
                    bl = true;
                } else {
                    System.out.println("RelocateSpec doesnot have a datastore");
                }
            } else {
                System.out.println("RelocateSpec doesnot have a resource pool");
            }
        } else {
            System.out.println("RelocateSpec doesnot have a host");
        }
        return bl;
    }
}

