/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.storage;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ClusterRecommendation;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PodStorageDrsEntry;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Sample(name="sdrs-recommendation", description="This sample demonstrates how to Run the Storage DRS on a given SDRS cluster and show\nthe list of recommendations generated by SDRS.\n")
public class SDRSRecommendation
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    String podName;

    @Option(name="podname", description="StoragePod name.")
    public void setPodName(String string) {
        this.podName = string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    SelectionSpec[] getStorageTraversalSpec() {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("visitFolders");
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("dcTodf");
        traversalSpec.setType("Datacenter");
        traversalSpec.setPath("datastoreFolder");
        traversalSpec.setSkip(Boolean.FALSE);
        traversalSpec.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setType("Folder");
        traversalSpec2.setName("visitFolders");
        traversalSpec2.setPath("childEntity");
        traversalSpec2.setSkip(Boolean.FALSE);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(traversalSpec);
        arrayList.add(selectionSpec);
        traversalSpec2.getSelectSet().addAll(arrayList);
        return new SelectionSpec[]{traversalSpec2};
    }

    ManagedObjectReference getStoragePodByName(String string) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference = null;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType("StoragePod");
        propertySpec.getPathSet().add("name");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.rootRef);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().addAll(Arrays.asList(this.getStorageTraversalSpec()));
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        if (list != null) {
            for (ObjectContent objectContent : list) {
                if (!((DynamicProperty)objectContent.getPropSet().get(0)).getVal().equals(string)) continue;
                managedObjectReference = objectContent.getObj();
                break;
            }
        }
        return managedObjectReference;
    }

    ObjectContent[] getObjectProperties(ManagedObjectReference managedObjectReference, String[] stringArray) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        if (managedObjectReference == null) {
            return null;
        }
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(new PropertySpec());
        if (stringArray == null || stringArray.length == 0) {
            ((PropertySpec)propertyFilterSpec.getPropSet().get(0)).setAll(Boolean.TRUE);
        } else {
            ((PropertySpec)propertyFilterSpec.getPropSet().get(0)).setAll(Boolean.FALSE);
        }
        ((PropertySpec)propertyFilterSpec.getPropSet().get(0)).setType(managedObjectReference.getType());
        ((PropertySpec)propertyFilterSpec.getPropSet().get(0)).getPathSet().addAll(Arrays.asList(stringArray));
        propertyFilterSpec.getObjectSet().add(new ObjectSpec());
        ((ObjectSpec)propertyFilterSpec.getObjectSet().get(0)).setObj(managedObjectReference);
        ((ObjectSpec)propertyFilterSpec.getObjectSet().get(0)).setSkip(Boolean.FALSE);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        return list.toArray(new ObjectContent[list.size()]);
    }

    Object getDynamicProperty(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        List list;
        ObjectContent[] objectContentArray = this.getObjectProperties(managedObjectReference, new String[]{"podStorageDrsEntry"});
        Object object = null;
        if (objectContentArray != null && (list = objectContentArray[0].getPropSet()) != null) {
            Object object2 = ((DynamicProperty)list.get(0)).getVal();
            String string = object2.getClass().getName();
            if (string.indexOf("ArrayOf") != -1) {
                String string2 = string.substring(string.indexOf("ArrayOf") + "ArrayOf".length(), string.length());
                string2 = this.methodExists(object2, "get" + string2, null) ? "get" + string2 : "get_" + string2.toLowerCase();
                Method method = object2.getClass().getDeclaredMethod(string2, null);
                object = method.invoke(object2, (Object[])null);
            } else {
                object = object2.getClass().isArray() ? object2 : object2;
            }
        }
        return object;
    }

    boolean methodExists(Object object, String string, Class[] classArray) throws NoSuchMethodException {
        boolean bl = false;
        Method method = object.getClass().getMethod(string, classArray);
        if (method != null) {
            bl = true;
        }
        return bl;
    }

    void storageRecommendation() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ManagedObjectReference managedObjectReference = this.serviceContent.getStorageResourceManager();
        ManagedObjectReference managedObjectReference2 = this.getStoragePodByName(this.podName);
        if (managedObjectReference2 != null) {
            this.vimPort.refreshStorageDrsRecommendation(managedObjectReference, managedObjectReference2);
            System.out.println("\nSuccess: Refresh Cluster Recommendation.");
            PodStorageDrsEntry podStorageDrsEntry = (PodStorageDrsEntry)this.getDynamicProperty(managedObjectReference2);
            List list = podStorageDrsEntry.getRecommendation();
            if (!list.isEmpty()) {
                System.out.println("\nList of recommendation: ");
                for (ClusterRecommendation clusterRecommendation : list) {
                    System.out.println(clusterRecommendation.getType() + " Reason: " + clusterRecommendation.getReason() + " target: " + clusterRecommendation.getTarget().getValue());
                }
            } else {
                System.out.println("\nNo Recommendations.");
            }
        } else {
            throw new RuntimeException("Failure: StoragePod " + this.podName + " not found.");
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvocationTargetException, InvalidPropertyFaultMsg, NoSuchMethodException, IllegalAccessException {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.storageRecommendation();
    }
}

