/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.simpleagent;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.Connection;
import com.vmware.connection.ConnectionFactory;
import com.vmware.security.credstore.CredentialStore;
import com.vmware.security.credstore.CredentialStoreFactory;
import java.io.IOException;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

@Sample(name="simple-agent", description="The SimpleAgent class uses the local credential store to obtain user account and password information, for automated logon to the target host system. SimpleAgent can be used with CreateUser, to demonstrate using the CredentialStore client API. SimpleAgent accesses the local credential store to obtain a single user account to login to the specified server (--hostName is the only common-line argument). If more than one user account exists in the credential store, an error message displays. To create user accounts and store them in the local credential store, use the CredentialStoreAdmin client utility. ")
public class SimpleAgent {
    String hostName = null;

    @Option(name="hostname", description=" The fully-qualified domain name of the server")
    public void setHostName(String string) {
        this.hostName = string;
    }

    @Action
    public void connectAndLogin() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, IllegalBlockSizeException, BadPaddingException {
        Connection connection = ConnectionFactory.newConnection();
        CredentialStore credentialStore = CredentialStoreFactory.getCredentialStore();
        String string = "";
        Set<String> set = credentialStore.getUsernames(this.hostName);
        if (set.size() == 0) {
            System.out.println("No user found in this host");
            return;
        }
        if (set.size() > 1) {
            System.out.println("Found two users for this host");
            return;
        }
        Object object = set.toArray();
        string = (String)object[0];
        object = "https://" + this.hostName + "/sdk/vimService";
        String string2 = credentialStore.getPassword(this.hostName, string);
        connection.setUrl((String)object);
        connection.setUsername(string);
        connection.setPassword(string2);
        connection.connect();
        System.out.println("Connected Successfully " + connection.getServiceContent().getAbout().getFullName());
        connection.disconnect();
    }
}

