/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfComplianceResult;
import com.vmware.vim25.ComplianceFailure;
import com.vmware.vim25.ComplianceResult;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.HostConfigFailedFaultMsg;
import com.vmware.vim25.HostConfigSpec;
import com.vmware.vim25.HostProfileHostBasedConfigSpec;
import com.vmware.vim25.HostProfileManagerConfigTaskList;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizableMessage;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ProfileCreateSpec;
import com.vmware.vim25.ProfileExecuteError;
import com.vmware.vim25.ProfileExecuteResult;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TimedoutFaultMsg;
import com.vmware.vim25.VirtualMachinePowerState;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Sample(name="host-profile-manager", description="demonstrates HostProfileManager and ProfileComplainceManager \n\nNOTE: this command may place a host into maintenance mode which will require VMs on the host to be suspended.\n\nCommand:\n\nCreate hostprofile given profileSourceHost (host system),  profileAttachEntity (host system), profileAttachEntityType (host system)\n\nApplies config after attaching hostprofile to  host system and check for compliance run.bat com.vmware.host.HostProfileManager --url [webserviceurl] --username [username] --password [password] --sourcehostname [host name] --entityname [host name] --entitytype HostSystem Create hostprofile given profileSourceHost (host system),  profileAttachEntity (cluster computer resource), profileAttachEntityType (cluster compute resource)\n\nAttaches hostprofile to all hosts in  cluster and checks for compliance \n\nrun.bat com.vmware.host.HostProfileManager --url [webserviceurl]--username [username] --password  [password]  --sourcehostname [host name] \n\n--entityname [Cluster] --entitytype ClusterComputeResource")
public class HostProfileManager
extends ConnectedVimServiceBase {
    private ManagedObjectReference hostprofileManager;
    private ManagedObjectReference profilecomplianceManager;
    private String createHostEntityName;
    private String attachEntityName;
    private String attachEntityType;
    private List<ManagedObjectReference> suspendedVMList;

    @Option(name="sourcehostname", description="Name of the host")
    public void setCreateHostEntityName(String string) {
        this.createHostEntityName = string;
    }

    @Option(name="entityname", description="Attached Entity Name")
    public void setAttachEntityName(String string) {
        this.attachEntityName = string;
    }

    @Option(name="entitytype", description="Attached Entity Type, example: HostSystem or ClusterComputeResource")
    public void setAttachEntityType(String string) {
        this.attachEntityType = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    ManagedObjectReference createHostProfile(ManagedObjectReference managedObjectReference) throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg {
        HostProfileHostBasedConfigSpec hostProfileHostBasedConfigSpec = new HostProfileHostBasedConfigSpec();
        hostProfileHostBasedConfigSpec.setHost(managedObjectReference);
        hostProfileHostBasedConfigSpec.setAnnotation("SDK Sample Host Profile");
        hostProfileHostBasedConfigSpec.setEnabled(Boolean.valueOf(true));
        hostProfileHostBasedConfigSpec.setName("SDK Profile " + this.createHostEntityName + " " + new Date().getTime());
        hostProfileHostBasedConfigSpec.setUseHostProfileEngine(Boolean.valueOf(true));
        System.out.println("--------------------");
        System.out.println("* Creating Host Profile");
        System.out.println("--------------------");
        System.out.println("Host : " + managedObjectReference.getValue());
        ManagedObjectReference managedObjectReference2 = this.vimPort.createProfile(this.hostprofileManager, (ProfileCreateSpec)hostProfileHostBasedConfigSpec);
        System.out.println("Profile : " + managedObjectReference2.getValue());
        return managedObjectReference2;
    }

    void attachProfileWithManagedEntity(ManagedObjectReference managedObjectReference, List<ManagedObjectReference> list) throws RuntimeFaultFaultMsg {
        System.out.println("------------------------");
        System.out.println("* Associating Host Profile");
        System.out.println("------------------------");
        this.vimPort.associateProfile(managedObjectReference, list);
        System.out.println("Associated " + managedObjectReference.getValue() + " with " + list.get(0).getValue());
    }

    void printProfilesAssociatedWithEntity(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg {
        System.out.println("------------------------------------");
        System.out.println("* Finding Associated Profiles with Host");
        System.out.println("------------------------------------");
        System.out.println("Profiles");
        for (ManagedObjectReference managedObjectReference2 : this.vimPort.findAssociatedProfile(this.hostprofileManager, managedObjectReference)) {
            System.out.println("    " + managedObjectReference2.getValue());
        }
    }

    void updateReferenceHost(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws RuntimeFaultFaultMsg {
        System.out.println("--------------------------------------");
        System.out.println("* Updating Reference Host for the Profile");
        System.out.println("--------------------------------------");
        this.vimPort.updateReferenceHost(managedObjectReference, managedObjectReference2);
        System.out.println("Updated Host Profile : " + managedObjectReference.getValue() + " Reference to " + managedObjectReference2.getValue());
    }

    HostConfigSpec executeHostProfile(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws RuntimeFaultFaultMsg {
        System.out.println("------------------------------");
        System.out.println("* Executing Profile Against Host");
        System.out.println("------------------------------");
        ProfileExecuteResult profileExecuteResult = this.vimPort.executeHostProfile(managedObjectReference, managedObjectReference2, null);
        System.out.println("Status : " + profileExecuteResult.getStatus());
        if (profileExecuteResult.getStatus().equals("success")) {
            System.out.println("Valid HostConfigSpec representing Configuration changes to be made on host");
            return profileExecuteResult.getConfigSpec();
        }
        if (profileExecuteResult.getStatus().equals("error")) {
            System.out.println("List of Errors");
            for (ProfileExecuteError profileExecuteError : profileExecuteResult.getError()) {
                System.out.println("    " + profileExecuteError.getMessage().getMessage());
            }
            return null;
        }
        return null;
    }

    void configurationTasksToBeAppliedOnHost(HostConfigSpec hostConfigSpec, ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        System.out.println("-------------------------------------------------------");
        System.out.println("* Config Tasks on the Host during HostProfile Application");
        System.out.println("-------------------------------------------------------");
        ManagedObjectReference managedObjectReference2 = this.vimPort.generateHostProfileTaskListTask(this.hostprofileManager, hostConfigSpec, managedObjectReference);
        if (this.getTaskResultAfterDone(managedObjectReference2)) {
            System.out.println("Done....");
            Map<String, Object> map = this.getMOREFs.entityProps(managedObjectReference2, new String[]{"info.result"});
            HostProfileManagerConfigTaskList hostProfileManagerConfigTaskList = (HostProfileManagerConfigTaskList)map.get("info.result");
            List list = hostProfileManagerConfigTaskList.getTaskDescription();
            if (list != null && !list.isEmpty()) {
                for (LocalizableMessage localizableMessage : list) {
                    System.out.println("Message : " + localizableMessage.getMessage());
                }
            } else {
                System.out.println("There are no configuration changes to be made");
            }
        } else {
            System.out.println("Operation Failed");
        }
    }

    boolean complianceStatusAndResults(Object object) {
        List list = ((ArrayOfComplianceResult)object).getComplianceResult();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            ComplianceResult complianceResult = (ComplianceResult)iterator.next();
            System.out.println("Host : " + complianceResult.getEntity().getValue());
            System.out.println("Profile : " + complianceResult.getProfile().getValue());
            System.out.println("Compliance Status : " + complianceResult.getComplianceStatus());
            if (complianceResult.getComplianceStatus().equals("nonCompliant")) {
                System.out.println("Compliance Failure Reason");
                for (ComplianceFailure complianceFailure : complianceResult.getFailure()) {
                    System.out.println(" " + complianceFailure.getMessage().getMessage());
                }
                return false;
            }
            return true;
        }
        return false;
    }

    boolean checkProfileCompliance(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws RemoteException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        System.out.println("---------------------------------------------");
        System.out.println("* Checking Complaince of Entity against Profile");
        System.out.println("---------------------------------------------");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("info.state");
        arrayList.add("info.error");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("state");
        ArrayList<ManagedObjectReference> arrayList3 = new ArrayList<ManagedObjectReference>();
        ArrayList<ManagedObjectReference> arrayList4 = new ArrayList<ManagedObjectReference>();
        arrayList3.add(managedObjectReference);
        arrayList4.add(managedObjectReference2);
        ManagedObjectReference managedObjectReference3 = this.vimPort.checkComplianceTask(this.profilecomplianceManager, arrayList3, arrayList4);
        if (!this.getTaskResultAfterDone(managedObjectReference3)) {
            throw new RuntimeException("Could not check the compliance of the profile with the given entity");
        }
        System.out.printf("Entity is Compliance against Profile.", new Object[0]);
        Object object = this.getMOREFs.entityProps(managedObjectReference3, new String[]{"info.result"}).get("info.result");
        return this.complianceStatusAndResults(object);
    }

    void applyConfigurationToHost(ManagedObjectReference managedObjectReference, HostConfigSpec hostConfigSpec) throws RemoteException, RuntimeFaultFaultMsg, InvalidStateFaultMsg, TimedoutFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, HostConfigFailedFaultMsg {
        System.out.println("----------------------------------------------------");
        System.out.println("* Applying Configuration changes or HostProfile to Host");
        System.out.println("----------------------------------------------------");
        System.out.println("Putting Host in Maintenance Mode");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("info.state");
        arrayList.add("info.error");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("state");
        this.suspendPoweredOnGuestVMs(managedObjectReference);
        ManagedObjectReference managedObjectReference2 = this.vimPort.enterMaintenanceModeTask(managedObjectReference, 0, null, null);
        Object[] objectArray = this.waitForValues.wait(managedObjectReference2, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (!objectArray[0].equals(TaskInfoState.SUCCESS)) {
            String string = "Failure: Entering Maintenance Mode Check and/or Configure Host Maintenance Mode Settings. Check that all Virtual Machines on this host are either suspended or powered off.";
            this.powerOnSuspendedGuestVMs(managedObjectReference);
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Entered Maintenance Mode ", new Object[0]);
        System.out.println("Applying Profile to Host");
        ManagedObjectReference managedObjectReference3 = this.vimPort.applyHostConfigTask(this.hostprofileManager, managedObjectReference, hostConfigSpec, null);
        Object[] objectArray2 = this.waitForValues.wait(managedObjectReference3, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (!objectArray2[0].equals(TaskInfoState.SUCCESS)) {
            this.exitMaintenanceMode(managedObjectReference);
            String string = "Failure: Apply configuration to Host";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Apply Configuration to Host ", new Object[0]);
        this.exitMaintenanceMode(managedObjectReference);
    }

    public void exitMaintenanceMode(ManagedObjectReference managedObjectReference) throws InvalidStateFaultMsg, RuntimeFaultFaultMsg, TimedoutFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference2 = this.vimPort.exitMaintenanceModeTask(managedObjectReference, 0);
        Object[] objectArray = this.waitForValues.wait(managedObjectReference2, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (!objectArray[0].equals(TaskInfoState.SUCCESS)) {
            throw new RuntimeException("Failure exiting maintenance mode.");
        }
        this.powerOnSuspendedGuestVMs(managedObjectReference);
    }

    public void powerOnSuspendedGuestVMs(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        for (ManagedObjectReference managedObjectReference2 : this.suspendedVMList) {
            System.out.println("\nPowering ON virtual machine : [" + managedObjectReference2.getValue() + "]");
            try {
                ManagedObjectReference managedObjectReference3 = this.vimPort.powerOnVMTask(managedObjectReference2, null);
                if (!this.getTaskResultAfterDone(managedObjectReference3)) continue;
                System.out.println("[" + managedObjectReference2.getValue() + "] powered on successfully");
            }
            catch (Exception exception) {
                System.out.println("Unable to power on vm : [" + managedObjectReference2.getValue() + "]");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    public void suspendPoweredOnGuestVMs(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Map<ManagedObjectReference, Map<String, Object>> map = this.getMOREFs.inContainerByType(managedObjectReference, "VirtualMachine", new String[]{"name", "runtime.powerState"}, new RetrieveOptions());
        this.suspendedVMList = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference managedObjectReference2 : map.keySet()) {
            Map<String, Object> map2 = map.get(managedObjectReference2);
            VirtualMachinePowerState virtualMachinePowerState = (VirtualMachinePowerState)map2.get("runtime.powerState");
            String string = (String)map2.get("name");
            if (!virtualMachinePowerState.equals((Object)VirtualMachinePowerState.POWERED_ON)) continue;
            try {
                ManagedObjectReference managedObjectReference3 = this.vimPort.suspendVMTask(managedObjectReference2);
                if (!this.getTaskResultAfterDone(managedObjectReference3)) continue;
                System.out.println(string + "[" + managedObjectReference2.getValue() + "] suspended successfully");
                this.suspendedVMList.add(managedObjectReference2);
            }
            catch (Exception exception) {
                System.out.println(string + "Unable to suspend vm : " + managedObjectReference2 + "[" + managedObjectReference2.getValue() + "]");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    void deleteHostProfile(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg {
        System.out.println("Deleting Profile");
        System.out.println("---------------");
        this.vimPort.destroyProfile(managedObjectReference);
        System.out.println("Profile : " + managedObjectReference.getValue());
    }

    void detachHostFromProfile(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws RuntimeFaultFaultMsg {
        System.out.println("------------------------");
        System.out.println("* Detach Host From Profile");
        System.out.println("------------------------");
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        arrayList.add(managedObjectReference2);
        this.vimPort.dissociateProfile(managedObjectReference, arrayList);
        System.out.println("Detached Host : " + ((ManagedObjectReference)arrayList.get(0)).getValue() + " From Profile : " + managedObjectReference.getValue());
    }

    @Action
    public void run() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, RemoteException, HostConfigFailedFaultMsg, InvalidStateFaultMsg, TimedoutFaultMsg {
        if (this.createHostEntityName == null || this.attachEntityName == null || this.attachEntityType == null) {
            throw new IllegalArgumentException("Expected --sourcehostname, --entityname, --entitytype arguments properly");
        }
        this.hostprofileManager = this.serviceContent.getHostProfileManager();
        this.profilecomplianceManager = this.serviceContent.getComplianceManager();
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", retrieveOptions);
        ManagedObjectReference managedObjectReference = map.get(this.createHostEntityName);
        if (managedObjectReference == null) {
            throw new IllegalStateException("HostSystem " + this.createHostEntityName);
        }
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), this.attachEntityType, retrieveOptions).get(this.attachEntityName);
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        arrayList.add(managedObjectReference2);
        ManagedObjectReference managedObjectReference3 = this.createHostProfile(managedObjectReference);
        this.attachProfileWithManagedEntity(managedObjectReference3, arrayList);
        this.printProfilesAssociatedWithEntity(managedObjectReference2);
        if (this.attachEntityType.equals("HostSystem")) {
            this.updateReferenceHost(managedObjectReference3, managedObjectReference2);
            HostConfigSpec hostConfigSpec = this.executeHostProfile(managedObjectReference3, managedObjectReference2);
            if (hostConfigSpec != null) {
                this.configurationTasksToBeAppliedOnHost(hostConfigSpec, managedObjectReference2);
            }
            if (this.checkProfileCompliance(managedObjectReference3, managedObjectReference2)) {
                this.applyConfigurationToHost(managedObjectReference2, hostConfigSpec);
            }
        } else {
            this.checkProfileCompliance(managedObjectReference3, managedObjectReference2);
        }
        this.detachHostFromProfile(managedObjectReference3, managedObjectReference2);
        this.deleteHostProfile(managedObjectReference3);
    }
}

