/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.guest;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.guest.GuestConnection;
import com.vmware.vim25.FileTransferInformation;
import com.vmware.vim25.GuestAuthentication;
import com.vmware.vim25.GuestProcessInfo;
import com.vmware.vim25.GuestProgramSpec;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NamePasswordAuthentication;
import com.vmware.vim25.VirtualMachinePowerState;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="run-program", description="This sample runs a specified program inside a virtual machine with\noutput re-directed to a temporary file inside the guest and\ndownloads the output file. Since vSphere API 5.0\n")
public class RunProgram
extends ConnectedVimServiceBase {
    private ManagedObjectReference vmMOR;
    private ManagedObjectReference fileManagerRef;
    private ManagedObjectReference processManagerRef;
    private ManagedObjectReference propCollector;
    private String tempFilePath;
    GuestConnection guestConnection;
    VirtualMachinePowerState powerState;
    Map<String, String> optionsmap = new HashMap<String, String>();
    NamePasswordAuthentication auth = null;
    String guestProgramPath;
    String localOutputFilePath;
    boolean interactive;

    @Option(name="guestConnection", type=GuestConnection.class)
    public void setGuestConnection(GuestConnection guestConnection) {
        this.guestConnection = guestConnection;
    }

    @Option(name="guestprogrampath", description="Fully qualified path of the program inside the guest.")
    public void setGuestProgramPath(String string) {
        this.guestProgramPath = string;
    }

    @Option(name="localoutputfilepath", description="Path to the local file to store the output.")
    public void setLocalOutputFilePath(String string) {
        this.localOutputFilePath = string;
    }

    @Option(name="interactivesession", required=false, description="Run the program within an interactive session inside the guest.")
    public void setInteractive(String string) {
        this.interactive = Boolean.valueOf(string) != false || "yes".equalsIgnoreCase(string);
    }

    void initAll() {
        this.initPropertyCollector();
        this.initRootFolder();
    }

    void initPropertyCollector() {
        if (this.propCollector == null) {
            this.propCollector = this.serviceContent.getPropertyCollector();
            if (this.propCollector == null) {
                throw new RunProgramException("Could not get Property Collector");
            }
        }
    }

    void initRootFolder() {
        if (this.rootRef == null) {
            this.rootRef = this.serviceContent.getRootFolder();
            if (this.rootRef == null) {
                throw new RunProgramException("Could not get Root Folder");
            }
        }
    }

    void getData(String string, String string2) throws IOException {
        HttpURLConnection httpURLConnection = null;
        URL uRL = new URL(string);
        httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        httpURLConnection.setRequestMethod("GET");
        InputStream inputStream = httpURLConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        byte[] byArray = new byte[102400];
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        int n2 = httpURLConnection.getResponseCode();
        httpURLConnection.disconnect();
        if (200 != n2) {
            throw new RunProgramException("File Download is unsuccessful");
        }
    }

    boolean verifyInputArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.guestProgramPath);
        arrayList.add(this.localOutputFilePath);
        for (String string : arrayList) {
            if (string != null) continue;
            return false;
        }
        return true;
    }

    @Action
    public void run() throws Exception, InvalidPropertyFaultMsg {
        String[] stringArray;
        String[] stringArray2;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        this.vmMOR = map.get(this.guestConnection.vmname);
        if (this.vmMOR != null) {
            System.out.println("Virtual Machine " + this.guestConnection.vmname + " found");
            this.powerState = (VirtualMachinePowerState)this.getMOREFs.entityProps(this.vmMOR, new String[]{"runtime.powerState"}).get("runtime.powerState");
            if (!this.powerState.equals((Object)VirtualMachinePowerState.POWERED_ON)) {
                System.out.println("VirtualMachine: " + this.guestConnection.vmname + " needs to be powered on");
                return;
            }
        } else {
            System.out.println("Virtual Machine " + this.guestConnection.vmname + " not found.");
            return;
        }
        boolean bl = this.interactive;
        if (bl) {
            stringArray2 = new String[]{"guest.interactiveGuestOperationsReady"};
            stringArray = new String[]{"guest.interactiveGuestOperationsReady"};
        } else {
            stringArray2 = new String[]{"guest.guestOperationsReady"};
            stringArray = new String[]{"guest.guestOperationsReady"};
        }
        this.waitForValues.wait(this.vmMOR, stringArray2, stringArray, new Object[][]{{true}});
        System.out.println("Guest Operations are ready for the VM");
        ManagedObjectReference managedObjectReference = this.serviceContent.getGuestOperationsManager();
        Map<String, Object> map2 = this.getMOREFs.entityProps(managedObjectReference, new String[]{"processManager", "fileManager"});
        this.fileManagerRef = (ManagedObjectReference)map2.get("fileManager");
        this.processManagerRef = (ManagedObjectReference)map2.get("processManager");
        this.auth = new NamePasswordAuthentication();
        this.auth.setUsername(this.guestConnection.username);
        this.auth.setPassword(this.guestConnection.password);
        this.auth.setInteractiveSession(bl);
        System.out.println("Executing CreateTemporaryFile guest operation");
        this.tempFilePath = this.vimPort.createTemporaryFileInGuest(this.fileManagerRef, this.vmMOR, (GuestAuthentication)this.auth, "", "", "");
        System.out.println("Successfully created a temporary file at: " + this.tempFilePath + " inside the guest");
        GuestProgramSpec guestProgramSpec = new GuestProgramSpec();
        guestProgramSpec.setProgramPath(this.guestProgramPath);
        guestProgramSpec.setArguments("> " + this.tempFilePath + " 2>&1");
        System.out.println("Starting the specified program inside the guest");
        long l = this.vimPort.startProgramInGuest(this.processManagerRef, this.vmMOR, (GuestAuthentication)this.auth, guestProgramSpec);
        System.out.println("Process ID of the program started is: " + l + "");
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(l);
        List list = null;
        do {
            System.out.println("Waiting for the process to finish running.");
            list = this.vimPort.listProcessesInGuest(this.processManagerRef, this.vmMOR, (GuestAuthentication)this.auth, arrayList);
            Thread.sleep(5000L);
        } while (((GuestProcessInfo)list.get(0)).getEndTime() == null);
        System.out.println("Exit code of the program is " + ((GuestProcessInfo)list.get(0)).getExitCode());
        FileTransferInformation fileTransferInformation = null;
        fileTransferInformation = this.vimPort.initiateFileTransferFromGuest(this.fileManagerRef, this.vmMOR, (GuestAuthentication)this.auth, this.tempFilePath);
        String string = fileTransferInformation.getUrl().replaceAll("\\*", this.connection.getHost());
        System.out.println("Downloading the output file from :" + string);
        this.getData(string, this.localOutputFilePath);
        System.out.println("Successfully downloaded the file");
    }

    private class RunProgramException
    extends RuntimeException {
        public RunProgramException(String string) {
            super(string);
        }
    }
}

