/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;
import java.util.ArrayList;
import java.util.List;

@Sample(name="simple-client", description="This sample lists the inventory contents (managed entities)")
public class SimpleClient
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    void getAndPrintInventoryContents() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("resourcePoolTraversalSpec");
        traversalSpec.setType("ResourcePool");
        traversalSpec.setPath("resourcePool");
        traversalSpec.setSkip(Boolean.FALSE);
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("resourcePoolTraversalSpec");
        traversalSpec.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setName("computeResourceRpTraversalSpec");
        traversalSpec2.setType("ComputeResource");
        traversalSpec2.setPath("resourcePool");
        traversalSpec2.setSkip(Boolean.FALSE);
        SelectionSpec selectionSpec2 = new SelectionSpec();
        selectionSpec2.setName("resourcePoolTraversalSpec");
        traversalSpec2.getSelectSet().add(selectionSpec2);
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setName("computeResourceHostTraversalSpec");
        traversalSpec3.setType("ComputeResource");
        traversalSpec3.setPath("host");
        traversalSpec3.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setName("datacenterHostTraversalSpec");
        traversalSpec4.setType("Datacenter");
        traversalSpec4.setPath("hostFolder");
        traversalSpec4.setSkip(Boolean.FALSE);
        SelectionSpec selectionSpec3 = new SelectionSpec();
        selectionSpec3.setName("folderTraversalSpec");
        traversalSpec4.getSelectSet().add(selectionSpec3);
        TraversalSpec traversalSpec5 = new TraversalSpec();
        traversalSpec5.setName("datacenterVmTraversalSpec");
        traversalSpec5.setType("Datacenter");
        traversalSpec5.setPath("vmFolder");
        traversalSpec5.setSkip(Boolean.FALSE);
        SelectionSpec selectionSpec4 = new SelectionSpec();
        selectionSpec4.setName("folderTraversalSpec");
        traversalSpec5.getSelectSet().add(selectionSpec4);
        TraversalSpec traversalSpec6 = new TraversalSpec();
        traversalSpec6.setName("folderTraversalSpec");
        traversalSpec6.setType("Folder");
        traversalSpec6.setPath("childEntity");
        traversalSpec6.setSkip(Boolean.FALSE);
        SelectionSpec selectionSpec5 = new SelectionSpec();
        selectionSpec5.setName("folderTraversalSpec");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(selectionSpec5);
        arrayList.add(traversalSpec4);
        arrayList.add(traversalSpec5);
        arrayList.add(traversalSpec2);
        arrayList.add(traversalSpec3);
        arrayList.add(traversalSpec);
        traversalSpec6.getSelectSet().addAll(arrayList);
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("name");
        propertySpec.setType("ManagedEntity");
        ArrayList<PropertySpec> arrayList2 = new ArrayList<PropertySpec>();
        arrayList2.add(propertySpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(arrayList2);
        propertyFilterSpec.getObjectSet().add(new ObjectSpec());
        ((ObjectSpec)propertyFilterSpec.getObjectSet().get(0)).setObj(this.rootRef);
        ((ObjectSpec)propertyFilterSpec.getObjectSet().get(0)).setSkip(Boolean.FALSE);
        ((ObjectSpec)propertyFilterSpec.getObjectSet().get(0)).getSelectSet().add(traversalSpec6);
        ArrayList<PropertyFilterSpec> arrayList3 = new ArrayList<PropertyFilterSpec>(1);
        arrayList3.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList3);
        if (list != null) {
            ObjectContent objectContent = null;
            ManagedObjectReference managedObjectReference = null;
            DynamicProperty dynamicProperty = null;
            for (int i = 0; i < list.size(); ++i) {
                objectContent = list.get(i);
                managedObjectReference = objectContent.getObj();
                List list2 = objectContent.getPropSet();
                System.out.println("Object Type : " + managedObjectReference.getType());
                System.out.println("Reference Value : " + managedObjectReference.getValue());
                if (list2 == null) continue;
                for (int j = 0; j < list2.size(); ++j) {
                    dynamicProperty = (DynamicProperty)list2.get(j);
                    System.out.println("   Property Name : " + dynamicProperty.getName());
                    if (dynamicProperty == null) continue;
                    if (!dynamicProperty.getVal().getClass().isArray()) {
                        System.out.println("   Property Value : " + dynamicProperty.getVal());
                        continue;
                    }
                    ArrayList<Object> arrayList4 = new ArrayList<Object>();
                    arrayList4.add(dynamicProperty.getVal());
                    System.out.println("Val : " + dynamicProperty.getVal());
                    for (int k = 0; k < arrayList4.size(); ++k) {
                        Object e = arrayList4.get(k);
                        if (e.getClass().getName().indexOf("ManagedObjectReference") >= 0) {
                            ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)e;
                            System.out.println("Inner Object Type : " + managedObjectReference2.getType());
                            System.out.println("Inner Reference Value : " + managedObjectReference2.getValue());
                            continue;
                        }
                        System.out.println("Inner Property Value : " + e);
                    }
                }
            }
        } else {
            System.out.println("No Managed Entities retrieved!");
        }
    }

    @Action
    public void main() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.getAndPrintInventoryContents();
    }
}

