/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ConcurrentAccessFaultMsg;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.HostListSummaryQuickStats;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MissingObject;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineQuickStats;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import com.vmware.vim25.WaitOptions;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;

@Sample(name="property-collector", description="This sample illustrates the property collector features added in version 4.1")
public class PropertyCollector
extends ConnectedVimServiceBase {
    public final String SVC_INST_NAME = "ServiceInstance";
    private ManagedObjectReference propCollectorRef = null;
    private String extension = null;
    private String vmName = null;
    private String maxObjects = null;
    private String updateType = null;
    private String noofTasks = null;
    private ManagedObjectReference rootFolderRef;

    @Option(name="extension", description="Extension to be demonstrated [retrieveproperties | updates | filterspec | propertycollector]")
    public void setExtension(String string) {
        this.extension = string;
    }

    @Option(name="vmname", required=false, description="Name of the virtual machine")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="maxobjects", required=false, description="The maximum number of ObjectContent data objects that should be returned in a single result")
    public void setMaxObjects(String string) {
        this.maxObjects = string;
    }

    @Option(name="updatetype", required=false, description="waitforupdates | checkforupdates| extension")
    public void setUpdateType(String string) {
        this.updateType = string;
    }

    @Option(name="nooftasks", required=false, description="Number of tasks to be created")
    public void setNoofTasks(String string) {
        this.noofTasks = string;
    }

    public void getInputParameters(String[] stringArray) throws IllegalArgumentException {
        String string = "";
        String string2 = "";
        for (int i = 0; i < stringArray.length; i += 2) {
            string = stringArray[i].trim();
            if (i + 1 < stringArray.length) {
                string2 = stringArray[i + 1].trim();
            }
            if (string.equalsIgnoreCase("--extension") && !string2.startsWith("--") && !string2.isEmpty()) {
                this.extension = string2;
            } else if (string.equalsIgnoreCase("--vmname") && !string2.startsWith("--") && !string2.isEmpty()) {
                this.vmName = string2;
            } else if (string.equalsIgnoreCase("--maxobjects") && !string2.startsWith("--") && !string2.isEmpty()) {
                this.maxObjects = string2;
            } else if (string.equalsIgnoreCase("--updatetype") && !string2.startsWith("--") && !string2.isEmpty()) {
                this.updateType = string2;
            } else if (string.equalsIgnoreCase("--nooftasks") && !string2.startsWith("--") && !string2.isEmpty()) {
                this.noofTasks = string2;
            }
            string2 = "";
        }
        if (this.extension == null) {
            throw new IllegalArgumentException("Expected --extension argument.");
        }
        if (this.extension != null) {
            if (!(this.extension.equalsIgnoreCase("retrieveproperties") || this.extension.equalsIgnoreCase("updates") || this.extension.equalsIgnoreCase("filterspec") || this.extension.equalsIgnoreCase("propertycollector"))) {
                throw new IllegalArgumentException("Invalid value for option extension. Possible values [retrieveproperties | updates | filterspec | propertycollector]");
            }
            if (this.extension.equalsIgnoreCase("updates") && (this.vmName == null || this.updateType == null)) {
                throw new IllegalArgumentException("For update extension. vmname and updatetype are mandatory argument");
            }
            if (this.extension.equalsIgnoreCase("filterspec") && (this.vmName == null || this.noofTasks == null)) {
                throw new IllegalArgumentException("For update extension. vmname and nooftasks are mandatory argument");
            }
        }
        if (!(this.updateType == null || this.updateType.equalsIgnoreCase("waitforupdates") || this.updateType.equalsIgnoreCase("checkforupdates") || this.updateType.equalsIgnoreCase("extension"))) {
            throw new IllegalArgumentException("Invalid value for option updatetype. Possible values [waitforupdates | checkforupdates | extension]");
        }
    }

    public void validate() {
        if (this.extension == null) {
            throw new IllegalArgumentException("Expected --extension argument.");
        }
        if (this.extension != null) {
            if (!(this.extension.equalsIgnoreCase("retrieveproperties") || this.extension.equalsIgnoreCase("updates") || this.extension.equalsIgnoreCase("filterspec") || this.extension.equalsIgnoreCase("propertycollector"))) {
                throw new IllegalArgumentException("Invalid value for option extension. Possible values [retrieveproperties | updates | filterspec | propertycollector]");
            }
            if (this.extension.equalsIgnoreCase("updates") && (this.vmName == null || this.updateType == null)) {
                throw new IllegalArgumentException("For update extension. vmname and updatetype are mandatory argument");
            }
            if (this.extension.equalsIgnoreCase("filterspec") && (this.vmName == null || this.noofTasks == null)) {
                throw new IllegalArgumentException("For filterspec extension. vmname and nooftasks are mandatory argument");
            }
        }
        if (!(this.updateType == null || this.updateType.equalsIgnoreCase("waitforupdates") || this.updateType.equalsIgnoreCase("checkforupdates") || this.updateType.equalsIgnoreCase("extension"))) {
            throw new IllegalArgumentException("Invalid value for option updatetype. Possible values [waitforupdates | checkforupdates | extension]");
        }
    }

    public void doOperations() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, InsufficientResourcesFaultFaultMsg, VmConfigFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg {
        if (this.extension.equalsIgnoreCase("retrieveproperties")) {
            if (this.maxObjects == null) {
                this.callRetrievePropertiesEx(null);
            } else {
                this.callRetrievePropertiesEx(this.maxObjects);
            }
        } else if (this.extension.equalsIgnoreCase("updates")) {
            if (this.updateType.equalsIgnoreCase("waitforupdates")) {
                this.callWaitForUpdatesEx(null, null);
            } else if (this.updateType.equalsIgnoreCase("checkforupdates")) {
                this.callWaitForUpdatesEx("60", null);
            } else if (this.updateType.equalsIgnoreCase("extension")) {
                this.callWaitForUpdatesEx("60", "1");
            }
        } else if (this.extension.equalsIgnoreCase("filterspec")) {
            int n = Integer.parseInt(this.noofTasks);
            List<ManagedObjectReference> list = this.createTasks(n);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("info.state");
            arrayList.add("info.error");
            this.callCreateFilterSpecEx(list, arrayList);
        } else if (this.extension.equalsIgnoreCase("propertycollector")) {
            this.callCreatePropertyCollectorEx();
        }
    }

    public void callCreatePropertyCollectorEx() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference = this.vimPort.createPropertyCollector(this.propCollectorRef);
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.valueOf(false));
        propertySpec.getPathSet().add("name");
        propertySpec.setType("VirtualMachine");
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        arrayList.add(propertySpec);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.rootFolderRef);
        objectSpec.setSkip(Boolean.valueOf(false));
        objectSpec.getSelectSet().addAll(this.buildFullTraversal());
        ArrayList<ObjectSpec> arrayList2 = new ArrayList<ObjectSpec>(0);
        arrayList2.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(arrayList);
        propertyFilterSpec.getObjectSet().addAll(arrayList2);
        ArrayList<PropertyFilterSpec> arrayList3 = new ArrayList<PropertyFilterSpec>();
        arrayList3.add(propertyFilterSpec);
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(managedObjectReference, arrayList3, retrieveOptions);
        List list = retrieveResult.getObjects();
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("VM : " + ((ObjectContent)list.get(i)).getObj().getValue());
        }
        this.vimPort.destroyPropertyCollector(managedObjectReference);
    }

    public void callCreateFilterSpecEx(List<ManagedObjectReference> list, List<String> list2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        Object object;
        PropertySpec propertySpec;
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<PropertySpec> arrayList2 = new ArrayList<PropertySpec>();
        for (int i = 0; i < list.size(); ++i) {
            propertySpec = new PropertySpec();
            propertySpec.getPathSet().addAll(list2);
            propertySpec.setType("Task");
            arrayList2.add(propertySpec);
            object = new ObjectSpec();
            object.setObj(list.get(i));
            object.getSelectSet().add(null);
            object.setSkip(Boolean.valueOf(false));
            arrayList.add(object);
        }
        propertyFilterSpec.getPropSet().addAll(arrayList2);
        propertyFilterSpec.getObjectSet().addAll(arrayList);
        propertyFilterSpec.setReportMissingObjectsInResults(Boolean.valueOf(true));
        ManagedObjectReference managedObjectReference = this.vimPort.createFilter(this.propCollectorRef, propertyFilterSpec, false);
        propertySpec = null;
        propertySpec = this.vimPort.waitForUpdates(this.propCollectorRef, "");
        object = propertySpec.getFilterSet();
        if (((PropertyFilterUpdate)object.get(0)).getMissingSet() != null && ((PropertyFilterUpdate)object.get(0)).getMissingSet().size() > 0) {
            for (int i = 0; i < ((PropertyFilterUpdate)object.get(0)).getMissingSet().size(); ++i) {
                System.out.println("Managed Object Reference " + ((MissingObject)((PropertyFilterUpdate)object.get(0)).getMissingSet().get(i)).getObj().getValue() + " Not Found");
            }
        }
        System.out.println("FilterSpec created successfully");
        this.vimPort.destroyPropertyFilter(managedObjectReference);
    }

    public List<ManagedObjectReference> createTasks(int n) throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        ManagedObjectReference managedObjectReference = map.get(this.vmName);
        if (managedObjectReference == null) {
            System.out.println("Virtual Machine " + this.vmName + " Not Found");
            return null;
        }
        for (int i = 0; i < n; ++i) {
            String string = "Temp";
            VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
            virtualMachineConfigSpec.setAnnotation(string);
            arrayList.add(this.vimPort.reconfigVMTask(managedObjectReference, virtualMachineConfigSpec));
            this.getTaskResultAfterDone((ManagedObjectReference)arrayList.get(i));
        }
        return arrayList;
    }

    public void callWaitForUpdatesEx(String string, String string2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        UpdateSet updateSet;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        ManagedObjectReference managedObjectReference = map.get(this.vmName);
        if (managedObjectReference == null) {
            System.out.println("Virtual Machine " + this.vmName + " Not Found");
            return;
        }
        String[][] stringArray = new String[][]{{"VirtualMachine", "name", "summary.quickStats", "runtime"}};
        List<PropertySpec> list = this.buildPropertySpecArray(stringArray);
        ArrayList<ObjectSpec> arrayList = new ArrayList<ObjectSpec>();
        boolean bl = managedObjectReference != null;
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(bl ? managedObjectReference : this.rootFolderRef);
        objectSpec.setSkip(new Boolean(!bl));
        if (!bl) {
            objectSpec.getSelectSet().addAll(this.buildFullTraversal());
        }
        arrayList.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(list);
        propertyFilterSpec.getObjectSet().addAll(arrayList);
        propertyFilterSpec.setReportMissingObjectsInResults(Boolean.valueOf(false));
        ManagedObjectReference managedObjectReference2 = this.propCollectorRef;
        ManagedObjectReference managedObjectReference3 = this.vimPort.createFilter(managedObjectReference2, propertyFilterSpec, false);
        WaitOptions waitOptions = new WaitOptions();
        if (string != null || string2 != null) {
            if (string != null) {
                waitOptions.setMaxWaitSeconds(Integer.valueOf(Integer.parseInt(string)));
            } else if (string2 != null) {
                waitOptions.setMaxObjectUpdates(Integer.valueOf(Integer.parseInt(string2)));
            }
        }
        if ((updateSet = this.vimPort.waitForUpdatesEx(this.propCollectorRef, null, waitOptions)).isTruncated() != null && updateSet.isTruncated().booleanValue()) {
            this.callWaitForUpdatesEx(string, string2);
        } else if (updateSet != null && updateSet.getFilterSet() != null) {
            this.handleUpdate(updateSet);
        } else {
            System.out.println("No update is present!");
        }
        this.vimPort.destroyPropertyFilter(managedObjectReference3);
    }

    public void callRetrievePropertiesEx(String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveResult retrieveResult;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.valueOf(false));
        propertySpec.getPathSet().add("name");
        propertySpec.setType("VirtualMachine");
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>(1);
        arrayList.add(propertySpec);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.rootFolderRef);
        objectSpec.setSkip(Boolean.valueOf(false));
        objectSpec.getSelectSet().addAll(this.buildFullTraversal());
        ArrayList<ObjectSpec> arrayList2 = new ArrayList<ObjectSpec>();
        arrayList2.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(arrayList);
        propertyFilterSpec.getObjectSet().addAll(arrayList2);
        ArrayList<PropertyFilterSpec> arrayList3 = new ArrayList<PropertyFilterSpec>();
        arrayList3.add(propertyFilterSpec);
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        if (string != null) {
            retrieveOptions.setMaxObjects(Integer.valueOf(Integer.parseInt(string)));
        }
        if ((retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, arrayList3, retrieveOptions)) != null) {
            List list = retrieveResult.getObjects();
            if (retrieveResult.getToken() != null && string == null) {
                this.callContinueRetrieveProperties(retrieveResult.getToken());
            }
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("VM Managed Object Reference Value: " + ((ObjectContent)list.get(i)).getObj().getValue());
            }
        } else {
            System.out.println("No VMs in inventory");
        }
    }

    public void callContinueRetrieveProperties(String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveResult retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
        List list = retrieveResult.getObjects();
        if (retrieveResult.getToken() != null) {
            this.callContinueRetrieveProperties(retrieveResult.getToken());
        }
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("VM Managed Object Reference Value : " + ((ObjectContent)list.get(i)).getObj().getValue());
        }
    }

    public void handleUpdate(UpdateSet updateSet) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        List list = updateSet.getFilterSet();
        for (int i = 0; i < list.size(); ++i) {
            List list2 = ((PropertyFilterUpdate)list.get(i)).getObjectSet();
            for (int j = 0; j < list2.size(); ++j) {
                if (((ObjectUpdate)list2.get(j)).getObj().getType().equals("VirtualMachine")) {
                    arrayList.add(list2.get(j));
                    continue;
                }
                if (!((ObjectUpdate)list2.get(j)).getObj().getType().equals("HostSystem")) continue;
                arrayList2.add(list2.get(j));
            }
        }
        if (arrayList.size() > 0) {
            System.out.println("Virtual Machine updates:");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.handleObjectUpdate((ObjectUpdate)iterator.next());
            }
        }
        if (arrayList2.size() > 0) {
            System.out.println("Host updates:");
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                this.handleObjectUpdate((ObjectUpdate)iterator.next());
            }
        }
    }

    public void handleObjectUpdate(ObjectUpdate objectUpdate) {
        List list = objectUpdate.getChangeSet();
        if (objectUpdate.getKind() == ObjectUpdateKind.ENTER) {
            System.out.println(" New Data:");
            this.handleChanges(list);
        } else if (objectUpdate.getKind() == ObjectUpdateKind.LEAVE) {
            System.out.println(" Removed Data:");
            this.handleChanges(list);
        } else if (objectUpdate.getKind() == ObjectUpdateKind.MODIFY) {
            System.out.println(" Changed Data:");
            this.handleChanges(list);
        }
    }

    public void handleChanges(List<PropertyChange> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).getName();
            Object object = list.get(i).getVal();
            PropertyChangeOp propertyChangeOp = list.get(i).getOp();
            if (propertyChangeOp != PropertyChangeOp.REMOVE) {
                Object object2;
                Object object3;
                VirtualMachineQuickStats virtualMachineQuickStats;
                System.out.println("  Property Name: " + string);
                if ("summary.quickStats".equals(string)) {
                    if (object instanceof VirtualMachineQuickStats) {
                        virtualMachineQuickStats = (VirtualMachineQuickStats)object;
                        object3 = virtualMachineQuickStats.getOverallCpuUsage() == null ? "unavailable" : virtualMachineQuickStats.getOverallCpuUsage().toString();
                        object2 = virtualMachineQuickStats.getHostMemoryUsage() == null ? "unavailable" : virtualMachineQuickStats.getHostMemoryUsage().toString();
                        System.out.println("   Guest Status: " + virtualMachineQuickStats.getGuestHeartbeatStatus().toString());
                        System.out.println("   CPU Load %: " + (String)object3);
                        System.out.println("   Memory Load %: " + (String)object2);
                        continue;
                    }
                    if (!(object instanceof HostListSummaryQuickStats)) continue;
                    virtualMachineQuickStats = (HostListSummaryQuickStats)object;
                    object3 = virtualMachineQuickStats.getOverallCpuUsage() == null ? "unavailable" : virtualMachineQuickStats.getOverallCpuUsage().toString();
                    object2 = virtualMachineQuickStats.getOverallMemoryUsage() == null ? "unavailable" : virtualMachineQuickStats.getOverallMemoryUsage().toString();
                    System.out.println("   CPU Load %: " + (String)object3);
                    System.out.println("   Memory Load %: " + (String)object2);
                    continue;
                }
                if ("runtime".equals(string)) {
                    if (object instanceof VirtualMachineRuntimeInfo) {
                        virtualMachineQuickStats = (VirtualMachineRuntimeInfo)object;
                        System.out.println("   Power State: " + virtualMachineQuickStats.getPowerState().toString());
                        System.out.println("   Connection State: " + virtualMachineQuickStats.getConnectionState().toString());
                        object3 = virtualMachineQuickStats.getBootTime();
                        if (object3 != null) {
                            System.out.println("   Boot Time: " + ((XMLGregorianCalendar)object3).toString());
                        }
                        if ((object2 = virtualMachineQuickStats.getMemoryOverhead()) == null) continue;
                        System.out.println("   Memory Overhead: " + object2);
                        continue;
                    }
                    if (!(object instanceof HostRuntimeInfo)) continue;
                    virtualMachineQuickStats = (HostRuntimeInfo)object;
                    System.out.println("   Connection State: " + virtualMachineQuickStats.getConnectionState().toString());
                    object3 = virtualMachineQuickStats.getBootTime();
                    if (object3 == null) continue;
                    System.out.println("   Boot Time: " + ((XMLGregorianCalendar)object3).toString());
                    continue;
                }
                if ("name".equals(string)) {
                    System.out.println("   " + object);
                    continue;
                }
                System.out.println("   " + object.toString());
                continue;
            }
            System.out.println("Property Name: " + string + " value removed.");
        }
    }

    public List<SelectionSpec> buildFullTraversal() {
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("rpToVm");
        traversalSpec.setType("ResourcePool");
        traversalSpec.setPath("vm");
        traversalSpec.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setName("vAppToVM");
        traversalSpec2.setType("VirtualApp");
        traversalSpec2.setPath("vm");
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setType("HostSystem");
        traversalSpec3.setPath("vm");
        traversalSpec3.setName("hToVm");
        traversalSpec3.getSelectSet().add(this.getSelectionSpec("VisitFolders"));
        traversalSpec3.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setType("Datacenter");
        traversalSpec4.setPath("datastore");
        traversalSpec4.setName("dcToDs");
        traversalSpec4.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec5 = new TraversalSpec();
        traversalSpec5.setType("ResourcePool");
        traversalSpec5.setPath("resourcePool");
        traversalSpec5.setSkip(Boolean.FALSE);
        traversalSpec5.setName("rpToRp");
        traversalSpec5.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        TraversalSpec traversalSpec6 = new TraversalSpec();
        traversalSpec6.setType("ComputeResource");
        traversalSpec6.setPath("resourcePool");
        traversalSpec6.setSkip(Boolean.FALSE);
        traversalSpec6.setName("crToRp");
        traversalSpec6.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        TraversalSpec traversalSpec7 = new TraversalSpec();
        traversalSpec7.setSkip(Boolean.FALSE);
        traversalSpec7.setType("ComputeResource");
        traversalSpec7.setPath("host");
        traversalSpec7.setName("crToH");
        TraversalSpec traversalSpec8 = new TraversalSpec();
        traversalSpec8.setSkip(Boolean.FALSE);
        traversalSpec8.setType("Datacenter");
        traversalSpec8.setPath("hostFolder");
        traversalSpec8.setName("dcToHf");
        traversalSpec8.getSelectSet().add(this.getSelectionSpec("VisitFolders"));
        TraversalSpec traversalSpec9 = new TraversalSpec();
        traversalSpec9.setName("vAppToRp");
        traversalSpec9.setType("VirtualApp");
        traversalSpec9.setPath("resourcePool");
        traversalSpec9.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        TraversalSpec traversalSpec10 = new TraversalSpec();
        traversalSpec10.setType("Datacenter");
        traversalSpec10.setSkip(Boolean.FALSE);
        traversalSpec10.setPath("vmFolder");
        traversalSpec10.setName("dcToVmf");
        traversalSpec10.getSelectSet().add(this.getSelectionSpec("VisitFolders"));
        TraversalSpec traversalSpec11 = new TraversalSpec();
        traversalSpec11.setType("Folder");
        traversalSpec11.setPath("childEntity");
        traversalSpec11.setSkip(Boolean.FALSE);
        traversalSpec11.setName("VisitFolders");
        ArrayList<SelectionSpec> arrayList = new ArrayList<SelectionSpec>();
        arrayList.add(this.getSelectionSpec("crToRp"));
        arrayList.add(this.getSelectionSpec("crToH"));
        arrayList.add(this.getSelectionSpec("dcToVmf"));
        arrayList.add(this.getSelectionSpec("dcToHf"));
        arrayList.add(this.getSelectionSpec("vAppToRp"));
        arrayList.add(this.getSelectionSpec("vAppToVM"));
        arrayList.add(this.getSelectionSpec("dcToDs"));
        arrayList.add(this.getSelectionSpec("hToVm"));
        arrayList.add(this.getSelectionSpec("rpToVm"));
        arrayList.add(this.getSelectionSpec("VisitFolders"));
        traversalSpec11.getSelectSet().addAll(arrayList);
        ArrayList<SelectionSpec> arrayList2 = new ArrayList<SelectionSpec>();
        arrayList2.add((SelectionSpec)traversalSpec11);
        arrayList2.add((SelectionSpec)traversalSpec6);
        arrayList2.add((SelectionSpec)traversalSpec7);
        arrayList2.add((SelectionSpec)traversalSpec10);
        arrayList2.add((SelectionSpec)traversalSpec8);
        arrayList2.add((SelectionSpec)traversalSpec9);
        arrayList2.add((SelectionSpec)traversalSpec2);
        arrayList2.add((SelectionSpec)traversalSpec4);
        arrayList2.add((SelectionSpec)traversalSpec3);
        arrayList2.add((SelectionSpec)traversalSpec);
        arrayList2.add((SelectionSpec)traversalSpec5);
        return arrayList2;
    }

    public SelectionSpec getSelectionSpec(String string) {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName(string);
        return selectionSpec;
    }

    public List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    public List<PropertySpec> buildPropertySpecArray(String[][] stringArray) {
        Object object;
        Collection collection;
        HashMap<String, AbstractCollection> hashMap = new HashMap<String, AbstractCollection>();
        for (int i = 0; i < stringArray.length; ++i) {
            collection = (Set)hashMap.get(stringArray[i][0]);
            if (collection == null) {
                collection = new HashSet();
                hashMap.put(stringArray[i][0], (AbstractCollection)collection);
            }
            boolean bl = false;
            for (int j = 0; j < stringArray[i].length; ++j) {
                object = stringArray[i][j];
                if (bl) {
                    collection.add(object);
                    continue;
                }
                bl = true;
            }
        }
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        for (String string : hashMap.keySet()) {
            PropertySpec propertySpec = new PropertySpec();
            object = (Set)hashMap.get(string);
            propertySpec.setType(string);
            propertySpec.setAll(object.isEmpty() ? Boolean.TRUE : Boolean.FALSE);
            int n = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                propertySpec.getPathSet().add(n++, string2);
            }
            arrayList.add(propertySpec);
        }
        collection = new ArrayList();
        collection.addAll(arrayList);
        return collection;
    }

    public boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    @Action
    public void main() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg {
        this.validate();
        this.rootFolderRef = this.serviceContent.getRootFolder();
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.doOperations();
    }
}

