/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;

@Sample(name="get-updates", description="This sample demonstrates how to use the PropertyCollector to monitor one or more properties of one or more managed objects.")
public class GetUpdates
extends ConnectedVimServiceBase {
    private String virtualmachinename;
    private ManagedObjectReference propCollectorRef;

    @Option(name="vmname", description="name of the virtual machine", required=false)
    public void setVmname(String string) {
        this.virtualmachinename = string;
    }

    private static SelectionSpec[] buildVMTraversal() {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("VisitFolders");
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setType("Datacenter");
        traversalSpec.setSkip(Boolean.FALSE);
        traversalSpec.setPath("vmFolder");
        traversalSpec.setName("dcToVmf");
        traversalSpec.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setType("Folder");
        traversalSpec2.setPath("childEntity");
        traversalSpec2.setSkip(Boolean.FALSE);
        traversalSpec2.setName("VisitFolders");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(traversalSpec);
        arrayList.add(selectionSpec);
        traversalSpec2.getSelectSet().addAll(arrayList);
        return new SelectionSpec[]{traversalSpec2};
    }

    public void getUpdates() throws RuntimeFaultFaultMsg, IOException, InvalidCollectorVersionFaultMsg, InvalidPropertyFaultMsg {
        String string;
        ManagedObjectReference managedObjectReference = this.getMOREFs.vmByVMname(this.virtualmachinename, this.propCollectorRef);
        if (managedObjectReference == null && this.virtualmachinename != null) {
            System.out.println("Virtual Machine " + this.virtualmachinename + " Not Found");
            return;
        }
        String[][] stringArray = new String[][]{{"VirtualMachine", "name", "runtime"}};
        List<PropertySpec> list = this.buildPropertySpecArray(stringArray);
        ArrayList<ObjectSpec> arrayList = new ArrayList<ObjectSpec>();
        boolean bl = managedObjectReference != null;
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(bl ? managedObjectReference : this.rootRef);
        objectSpec.setSkip(new Boolean(!bl));
        if (!bl) {
            objectSpec.getSelectSet().addAll(Arrays.asList(GetUpdates.buildVMTraversal()));
        }
        arrayList.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(list);
        propertyFilterSpec.getObjectSet().addAll(arrayList);
        ManagedObjectReference managedObjectReference2 = this.vimPort.createFilter(this.propCollectorRef, propertyFilterSpec, false);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string2 = "";
        do {
            UpdateSet updateSet;
            if ((updateSet = this.vimPort.waitForUpdatesEx(this.propCollectorRef, string2, null)) != null && updateSet.getFilterSet() != null) {
                this.handleUpdate(updateSet);
                string2 = updateSet.getVersion();
            } else {
                System.out.println("No update is present!");
            }
            System.out.println("");
            System.out.println("Press <Enter> to check for updates");
            System.out.println("Enter 'exit' <Enter> to exit the program");
        } while ((string = bufferedReader.readLine()) == null || !string.trim().equalsIgnoreCase("exit"));
        this.vimPort.destroyPropertyFilter(managedObjectReference2);
    }

    void handleUpdate(UpdateSet updateSet) {
        ArrayList<ObjectUpdate> arrayList = new ArrayList<ObjectUpdate>();
        List list = updateSet.getFilterSet();
        for (PropertyFilterUpdate propertyFilterUpdate : list) {
            List list2 = propertyFilterUpdate.getObjectSet();
            for (ObjectUpdate objectUpdate : list2) {
                if (!objectUpdate.getObj().getType().equals("VirtualMachine")) continue;
                arrayList.add(objectUpdate);
            }
        }
        if (arrayList.size() > 0) {
            System.out.println("Virtual Machine updates:");
            for (ObjectUpdate objectUpdate : arrayList) {
                this.handleObjectUpdate(objectUpdate);
            }
        }
    }

    void handleObjectUpdate(ObjectUpdate objectUpdate) {
        List list = objectUpdate.getChangeSet();
        if (objectUpdate.getKind() == ObjectUpdateKind.ENTER) {
            System.out.println(" New Data:");
            this.handleChanges(list);
        } else if (objectUpdate.getKind() == ObjectUpdateKind.LEAVE) {
            System.out.println(" Removed Data:");
            this.handleChanges(list);
        } else if (objectUpdate.getKind() == ObjectUpdateKind.MODIFY) {
            System.out.println(" Changed Data:");
            this.handleChanges(list);
        }
    }

    void handleChanges(List<PropertyChange> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).getName();
            Object object = list.get(i).getVal();
            PropertyChangeOp propertyChangeOp = list.get(i).getOp();
            if (propertyChangeOp != PropertyChangeOp.REMOVE) {
                System.out.println("  Property Name: " + string);
                if ("runtime".equals(string)) {
                    Long l;
                    if (!(object instanceof VirtualMachineRuntimeInfo)) continue;
                    VirtualMachineRuntimeInfo virtualMachineRuntimeInfo = (VirtualMachineRuntimeInfo)object;
                    System.out.println("   Power State: " + virtualMachineRuntimeInfo.getPowerState().toString());
                    System.out.println("   Connection State: " + virtualMachineRuntimeInfo.getConnectionState().toString());
                    XMLGregorianCalendar xMLGregorianCalendar = virtualMachineRuntimeInfo.getBootTime();
                    if (xMLGregorianCalendar != null) {
                        System.out.println("   Boot Time: " + xMLGregorianCalendar.toGregorianCalendar().getTime());
                    }
                    if ((l = virtualMachineRuntimeInfo.getMemoryOverhead()) == null) continue;
                    System.out.println("   Memory Overhead: " + l);
                    continue;
                }
                if ("name".equals(string)) {
                    System.out.println("   " + object);
                    continue;
                }
                System.out.println("   " + object.toString());
                continue;
            }
            System.out.println("Property Name: " + string + " value removed.");
        }
    }

    List<PropertySpec> buildPropertySpecArray(String[][] stringArray) {
        Object object;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            Set<Object> set = (Set)hashMap.get(stringArray[i][0]);
            if (set == null) {
                set = new HashSet<Object>();
                hashMap.put(stringArray[i][0], set);
            }
            boolean bl = false;
            for (int j = 0; j < stringArray[i].length; ++j) {
                object = stringArray[i][j];
                if (bl) {
                    set.add(object);
                    continue;
                }
                bl = true;
            }
        }
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        for (String string : hashMap.keySet()) {
            PropertySpec propertySpec = new PropertySpec();
            object = (Set)hashMap.get(string);
            propertySpec.setType(string);
            propertySpec.setAll(object.isEmpty() ? Boolean.TRUE : Boolean.FALSE);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                propertySpec.getPathSet().add(string2);
            }
            arrayList.add(propertySpec);
        }
        return arrayList;
    }

    @Action
    public void action() throws RuntimeFaultFaultMsg, IOException, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.getUpdates();
    }
}

