/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VimFaultFaultMsg;
import java.rmi.RemoteException;
import java.util.Map;

@Sample(name="delete", description="This sample deletes the specified managed entity from the inventory tree The managed entity can be a virtual machine, ClusterComputeResource or a Folder.")
public class Delete
extends ConnectedVimServiceBase {
    private String managedEntityName;

    @Option(name="entityname", description="name of entity to delete")
    public void setManagedEntityName(String string) {
        this.managedEntityName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    @Action
    public void deleteManagedEntity() throws RuntimeFaultFaultMsg, RemoteException, InvalidPropertyFaultMsg, VimFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "ManagedEntity");
        ManagedObjectReference managedObjectReference = map.get(this.managedEntityName);
        if (managedObjectReference == null) {
            System.out.printf(" Unable to find a Managed Entity By name [ %s ]", this.managedEntityName);
            return;
        }
        ManagedObjectReference managedObjectReference2 = this.vimPort.destroyTask(managedObjectReference);
        if (this.getTaskResultAfterDone(managedObjectReference2)) {
            System.out.printf("Successful delete of Managed Entity Name - [ %s ] and Entity Type - [ %s ]%n", this.managedEntityName, managedObjectReference.getType());
        }
    }
}

