/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ClusterConfigSpec;
import com.vmware.vim25.ComputeResourceConfigSpec;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.HostConnectFaultFaultMsg;
import com.vmware.vim25.HostConnectSpec;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualMachineConfigInfoSwapPlacementType;
import java.util.Map;

@Sample(name="create", description="This sample creates managed entity like Host-Standalone, Cluster, Datacenter, and folder")
public class Create
extends ConnectedVimServiceBase {
    private String licenseKey;
    private String parentName;
    private String itemType;
    private String itemName;

    @Option(name="parentname", description="specifies the name of the parent folder")
    public void setParentName(String string) {
        this.parentName = string;
    }

    @Option(name="itemtype", description="Type of the object to be added, e.g. Host-Standalone | Cluster | Datacenter | Folder")
    public void setItemType(String string) {
        this.itemType = string;
    }

    @Option(name="itemname", description="Name of the item added")
    public void setItemName(String string) {
        this.itemName = string;
    }

    @Option(name="licensekey", required=false)
    public void setLicenseKey(String string) {
        this.licenseKey = string;
    }

    @Action
    public void create() throws DuplicateNameFaultMsg, InvalidNameFaultMsg, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, HostConnectFaultFaultMsg, InvalidLoginFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = null;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "Folder");
        if (map.containsKey(this.parentName)) {
            ManagedObjectReference managedObjectReference2 = map.get(this.parentName);
            if (this.itemType.equals("Folder")) {
                this.vimPort.createFolder(managedObjectReference2, this.itemName);
                System.out.println("Sucessfully created::" + this.itemName);
            } else if (this.itemType.equals("Datacenter")) {
                this.vimPort.createDatacenter(managedObjectReference2, this.itemName);
                System.out.println("Sucessfully created::" + this.itemName);
            } else if (this.itemType.equals("Cluster")) {
                ClusterConfigSpec clusterConfigSpec = new ClusterConfigSpec();
                this.vimPort.createCluster(managedObjectReference2, this.itemName, clusterConfigSpec);
                System.out.println("Sucessfully created::" + this.itemName);
            } else if (this.itemType.equals("Host-Standalone")) {
                HostConnectSpec hostConnectSpec = new HostConnectSpec();
                hostConnectSpec.setHostName(this.itemName);
                hostConnectSpec.setUserName(this.connection.getUsername());
                hostConnectSpec.setPassword(this.connection.getPassword());
                hostConnectSpec.setPort(this.connection.getPort());
                ComputeResourceConfigSpec computeResourceConfigSpec = new ComputeResourceConfigSpec();
                computeResourceConfigSpec.setVmSwapPlacement(VirtualMachineConfigInfoSwapPlacementType.VM_DIRECTORY.value());
                managedObjectReference = this.vimPort.addStandaloneHostTask(managedObjectReference2, hostConnectSpec, computeResourceConfigSpec, true, this.licenseKey);
                if (this.getTaskResultAfterDone(managedObjectReference)) {
                    System.out.println("Sucessfully created::" + this.itemName);
                } else {
                    System.out.println("Host'" + this.itemName + " not created::");
                }
            } else {
                System.out.println("Unknown Type. Allowed types are:");
                System.out.println(" Host-Standalone");
                System.out.println(" Cluster");
                System.out.println(" Datacenter");
                System.out.println(" Folder");
            }
        } else {
            System.out.println("Parent folder '" + this.parentName + "' not found");
        }
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }
}

