/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.AlreadyExistsFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VStorageObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Sample(name="fcd-registerlegacydisk", description="This sample registers a given legacy disk as First class disk.")
public class FcdRegisterLegacyDisk
extends ConnectedVimServiceBase {
    private String legacyDiskFileName;
    private String dataCenterName;
    private String fcdName;

    @Option(name="legacydiskfilename", required=true, description="File name of the legacy disk.")
    public void setLegacyDiskFileName(String string) {
        this.legacyDiskFileName = string;
    }

    @Option(name="datacentername", required=true, description="Name of the datacenter")
    public void setDataCenterName(String string) {
        this.dataCenterName = string;
    }

    @Option(name="fcdname", required=false, description="File name of the legacy disk.")
    public void setFcdName(String string) {
        this.fcdName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void registerDiskAsFCD() throws AlreadyExistsFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        String string = this.getDiskPathForVc(this.legacyDiskFileName);
        System.out.println("Operation: Register a legacy disk as FCD with disk Path :: " + string);
        VStorageObject vStorageObject = this.vimPort.registerDisk(managedObjectReference, string, this.fcdName);
        System.out.printf("Success: Registered Disk(now a vStorageObject) : [Uuid = %s ] with Name [ %s ]%n", vStorageObject.getConfig().getId().getId(), vStorageObject.getConfig().getName());
    }

    private String getDiskPathForVc(String string) {
        Object object;
        String string2 = "\\[(.*)\\]\\s(.*)/(.*\\.vmdk)";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (Pattern.matches(string2, string)) {
            System.out.println("Info: FileName Pattern matches required pattern.");
            object = Pattern.compile(string2);
            Matcher matcher = ((Pattern)object).matcher(string);
            if (matcher.find()) {
                string3 = matcher.group(1);
                string4 = matcher.group(2);
                string5 = matcher.group(3);
            }
        }
        object = "https://" + this.connection.getHost() + "/" + "folder/" + string4 + "/" + string5 + "?dcPath=" + this.dataCenterName + "&dsName=" + string3;
        return object;
    }

    @Action
    public void run() throws AlreadyExistsFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg {
        this.registerDiskAsFCD();
    }
}

