/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.fcd;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.fcd.helpers.FcdHelper;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;

@Sample(name="fcd-delete", description="This sample deletes a virtual storage object.")
public class FcdDelete
extends ConnectedVimServiceBase {
    private String vStorageObjectId;
    private String datastoreName;

    @Option(name="vstorageobjectid", required=true, description="Uuid of the vstorageobject.")
    public void setVStorageObjectId(String string) {
        this.vStorageObjectId = string;
    }

    @Option(name="datastorename", required=true, description="Name of datastore containing the  vstorageobject.")
    public void setDatastoreName(String string) {
        this.datastoreName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void deleteVStorageObject() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, TaskInProgressFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getVStorageObjectManager();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore").get(this.datastoreName);
        System.out.println("Operation: Deleting the given vStorageObject");
        ManagedObjectReference managedObjectReference3 = this.vimPort.deleteVStorageObjectTask(managedObjectReference, FcdHelper.makeId(this.vStorageObjectId), managedObjectReference2);
        if (!this.getTaskResultAfterDone(managedObjectReference3)) {
            String string = "Error: Deleting [ " + this.vStorageObjectId + "] vStorageObject";
            throw new RuntimeException(string);
        }
        System.out.printf("Success: Deleted vStorageObject :  %n [ Uuid = %s ]%n", this.vStorageObjectId);
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, TaskInProgressFaultMsg, InvalidCollectorVersionFaultMsg {
        this.deleteVStorageObject();
    }
}

