/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.connection;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.VimPortType;

public class KeepAlive
implements Runnable {
    public static final Long DEFAULT_INTERVAL = 300000L;
    private boolean verbose = Boolean.parseBoolean(System.getProperty("keep-alive.verbose", "false"));
    private Boolean running;
    private final Long interval;
    private final VimPortType vimPort;
    private final ManagedObjectReference serviceInstanceReference;

    public KeepAlive(VimPortType vimPortType, ManagedObjectReference managedObjectReference) {
        this(vimPortType, managedObjectReference, DEFAULT_INTERVAL);
    }

    public KeepAlive(VimPortType vimPortType, ManagedObjectReference managedObjectReference, Long l) {
        this.vimPort = vimPortType;
        this.serviceInstanceReference = managedObjectReference;
        this.interval = l;
        this.running = Boolean.TRUE;
    }

    public void keepAlive() {
        try {
            KeepAlive.run(this.vimPort, this.serviceInstanceReference);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            runtimeFaultFaultMsg.printStackTrace();
        }
        catch (Exception exception) {
            this.stop();
        }
    }

    public static void run(VimPortType vimPortType, ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg {
        vimPortType.currentTime(managedObjectReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Boolean bl;
        Boolean bl2 = this.running;
        synchronized (bl2) {
            bl = this.running;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Boolean bl = this.running;
        synchronized (bl) {
            if (this.verbose) {
                System.out.println("keep alive stopped");
            }
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Boolean bl = this.running;
        synchronized (bl) {
            this.running = true;
        }
        try {
            while (this.isRunning()) {
                if (this.verbose) {
                    System.out.println("keep alive");
                }
                this.keepAlive();
                Thread.sleep(this.interval);
            }
        }
        catch (Throwable throwable) {
            this.stop();
        }
    }

    public static Thread keepAlive(VimPortType vimPortType, ManagedObjectReference managedObjectReference) {
        return KeepAlive.keepAlive(vimPortType, managedObjectReference, DEFAULT_INTERVAL);
    }

    public static Thread keepAlive(VimPortType vimPortType, ManagedObjectReference managedObjectReference, Long l) {
        Thread thread = new Thread(new KeepAlive(vimPortType, managedObjectReference, l));
        return thread;
    }
}

