/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.connection;

import com.vmware.common.annotations.After;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.connection.BasicConnection;
import com.vmware.connection.Connection;
import com.vmware.connection.helpers.GetMOREF;
import com.vmware.connection.helpers.WaitForValues;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import java.util.Map;

public abstract class ConnectedVimServiceBase {
    public static final String PROP_ME_NAME = "name";
    public static final String SVC_INST_NAME = "ServiceInstance";
    protected Connection connection;
    protected VimPortType vimPort;
    protected ServiceContent serviceContent;
    protected ManagedObjectReference rootRef;
    protected Map headers;
    protected WaitForValues waitForValues;
    protected GetMOREF getMOREFs;
    Boolean hostConnection = Boolean.FALSE;

    @Option(name="basic-connection", required=false, description="Turn off the use of SSO for connections. Useful for connecting to ESX or ESXi hosts.", parameter=false)
    public void setHostConnection(Boolean bl) {
        this.hostConnection = bl;
    }

    public ManagedObjectReference getServiceInstanceReference() {
        return this.connection.getServiceInstanceReference();
    }

    @Option(name="connection", type=Connection.class)
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Before
    public Connection connect() {
        if (this.hostConnection.booleanValue()) {
            this.connection = this.basicConnectionFromConnection(this.connection);
        }
        try {
            this.connection.connect();
            this.waitForValues = new WaitForValues(this.connection);
            this.getMOREFs = new GetMOREF(this.connection);
            this.headers = this.connection.getHeaders();
            this.vimPort = this.connection.getVimPort();
            this.serviceContent = this.connection.getServiceContent();
            this.rootRef = this.serviceContent.getRootFolder();
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
            System.err.println("No valid connection available. Exiting now.");
            System.exit(0);
        }
        return this.connection;
    }

    public BasicConnection basicConnectionFromConnection(Connection connection) {
        BasicConnection basicConnection = new BasicConnection();
        basicConnection.setUrl(connection.getUrl());
        basicConnection.setUsername(connection.getUsername());
        basicConnection.setPassword(connection.getPassword());
        return basicConnection;
    }

    @After
    public Connection disconnect() {
        this.waitForValues = null;
        try {
            this.connection.disconnect();
        }
        catch (Throwable throwable) {
            throw new ConnectionException(throwable);
        }
        return this.connection;
    }

    public class ConnectionException
    extends RuntimeException {
        public ConnectionException(Throwable throwable) {
            super(throwable);
        }

        public ConnectionException(String string) {
            super(string);
        }
    }
}

