/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cim.helpers;

import com.vmware.connection.Connection;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.VimPortType;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GetHost {
    public final Connection connection;

    public GetHost(Connection connection) {
        this.connection = connection;
    }

    public boolean isIpAddress(String string) {
        InetAddress inetAddress = GetHost.address(string);
        return inetAddress != null && !inetAddress.isMulticastAddress() && !inetAddress.isLoopbackAddress();
    }

    public static InetAddress address(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        return inetAddress;
    }

    public static String resolve(InetAddress inetAddress) {
        return inetAddress != null ? inetAddress.toString() : "/";
    }

    public static String ipAddress(InetAddress inetAddress) {
        String string = GetHost.resolve(inetAddress);
        String[] stringArray = string.split("/");
        return stringArray != null && stringArray.length == 2 ? stringArray[1] : "";
    }

    public ManagedObjectReference byName(String string) {
        ManagedObjectReference managedObjectReference = null;
        VimPortType vimPortType = this.connection.getVimPort();
        ManagedObjectReference managedObjectReference2 = this.connection.getServiceContent().getSearchIndex();
        try {
            if (this.isIpAddress(string)) {
                InetAddress inetAddress = GetHost.address(string);
                String string2 = GetHost.ipAddress(inetAddress);
                if ("".equals(string2)) {
                    throw new GetHostRuntimeFault(String.format("could not properly verify '%s' as an IP address", string));
                }
                managedObjectReference = vimPortType.findByIp(managedObjectReference2, null, string2, false);
            } else {
                managedObjectReference = vimPortType.findByDnsName(managedObjectReference2, null, string, false);
            }
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new GetHostRuntimeFault((Throwable)runtimeFaultFaultMsg);
        }
        return managedObjectReference;
    }

    public GetHost vCenterCheck() {
        String string = this.getType();
        if (!string.equals("VirtualCenter")) {
            throw new IsNotvCenterException(this.connection.getHost() + " is " + string);
        }
        return this;
    }

    public GetHost hostCheck() {
        String string = this.getType();
        if (string.equals("VirtualCenter")) {
            throw new IsNotHostAgentException(this.connection.getHost() + " is " + string);
        }
        return this;
    }

    public String getType() {
        String string;
        try {
            string = this.connection.connect().getServiceContent().getAbout().getApiType();
        }
        catch (Throwable throwable) {
            string = "";
        }
        return string;
    }

    public class IsNotHostAgentException
    extends GetHostRuntimeFault {
        private static final long serialVersionUID = 1L;

        public IsNotHostAgentException(String string) {
            super(string);
        }
    }

    public class IsNotvCenterException
    extends GetHostRuntimeFault {
        private static final long serialVersionUID = 1L;

        public IsNotvCenterException(String string) {
            super(string);
        }
    }

    private class GetHostRuntimeFault
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public GetHostRuntimeFault(Throwable throwable) {
            super(throwable);
        }

        public GetHostRuntimeFault(String string) {
            super(string);
        }

        public GetHostRuntimeFault(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

