/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.client.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SecurityUtil {
    private PrivateKey privateKey;
    private X509Certificate userCert;

    public static SecurityUtil loadFromKeystore(String string, String string2, String string3) {
        try {
            return new SecurityUtil().loadKeystore(string, string2, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Exception reading loading the user certificates from keystore", exception);
        }
    }

    public static SecurityUtil loadFromFiles(String string, String string2) {
        try {
            return new SecurityUtil().loadPrivateKey(string).loadX509Cert(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Exception loading the private key / certificates from files", exception);
        }
    }

    public static SecurityUtil generateKeyCertPair() {
        try {
            SecurityUtil securityUtil = new SecurityUtil();
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            securityUtil.userCert = SecurityUtil.generateCertificate("CN=*.vmware.com, OU=Ecosystem Engineering, O=\"VMware, Inc.\", L=Palo Alto, ST=California, C=US", keyPair, 365, "SHA1withRSA");
            securityUtil.privateKey = keyPair.getPrivate();
            return securityUtil;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
            throw new RuntimeException(generalSecurityException);
        }
        catch (OperatorCreationException operatorCreationException) {
            operatorCreationException.printStackTrace();
            throw new RuntimeException(operatorCreationException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    private static X509Certificate generateCertificate(String string, KeyPair keyPair, int n, String string2) throws GeneralSecurityException, IOException, OperatorCreationException {
        Date date = new Date();
        Date date2 = new Date(System.currentTimeMillis() + (long)n * 86400000L);
        BigInteger bigInteger = new BigInteger(64, new SecureRandom());
        X500Name x500Name = new X500Name(string);
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(x500Name, bigInteger, date, date2, x500Name, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        ContentSigner contentSigner = new JcaContentSignerBuilder(string2).build(keyPair.getPrivate());
        X509CertificateHolder x509CertificateHolder = x509v3CertificateBuilder.build(contentSigner);
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        return jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
    }

    private SecurityUtil loadKeystore(String string, String string2, String string3) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException, CertificateException, IOException {
        File file = new File(string);
        if (!file.isFile()) {
            System.out.println("Keystore file not found");
        }
        System.out.println("Loading KeyStore " + file + "...");
        FileInputStream fileInputStream = new FileInputStream(file);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] cArray = string2.toCharArray();
        keyStore.load(fileInputStream, cArray);
        ((InputStream)fileInputStream).close();
        if (keyStore.isKeyEntry(string3)) {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string3, new KeyStore.PasswordProtection(cArray));
            this.privateKey = privateKeyEntry.getPrivateKey();
            if (privateKeyEntry.getCertificate() instanceof X509Certificate) {
                this.userCert = (X509Certificate)privateKeyEntry.getCertificate();
            }
        }
        return this;
    }

    private SecurityUtil loadPrivateKey(String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        this.privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
        return this;
    }

    private SecurityUtil loadX509Cert(String string) throws IOException, CertificateException {
        System.out.println("Loading X509 Certificate from " + string + "...");
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        while (bufferedInputStream.available() > 0) {
            this.userCert = (X509Certificate)certificateFactory.generateCertificate(bufferedInputStream);
        }
        return this;
    }

    private SecurityUtil() {
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getUserCert() {
        return this.userCert;
    }
}

