/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.reflection;

import com.vmware.common.samples.reflection.ClassScanner;
import com.vmware.common.samples.reflection.SampleReflectionException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JarFileClassScanner
implements ClassScanner {
    private final String classFileSuffix;

    public JarFileClassScanner(String classFileSuffix) {
        this.classFileSuffix = classFileSuffix;
    }

    @Override
    public Collection<String> scan(URL url) {
        Collection<String> out = null;
        try {
            out = this.scanJarFile(url);
        }
        catch (IOException e) {
            throw new SampleJarFileReflectionException(e);
        }
        return out;
    }

    private Collection<String> scanJarFile(URL url) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        JarInputStream jarInputStream = new JarInputStream(url.openStream());
        JarEntry entry = jarInputStream.getNextJarEntry();
        while (entry != null) {
            String name = entry.toString();
            if (name.endsWith(this.classFileSuffix)) {
                String className = name.substring(0, name.length() - this.classFileSuffix.length()).replaceAll("\\\\|/", ".");
                classNames.add(className);
            }
            entry = jarInputStream.getNextJarEntry();
        }
        return classNames;
    }

    private class SampleJarFileReflectionException
    extends SampleReflectionException {
        private static final long serialVersionUID = 1L;

        public SampleJarFileReflectionException(IOException e) {
            super("typically thrown due to a classpath problem", e);
        }
    }
}

