/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples;

import com.vmware.common.Main;
import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.After;
import com.vmware.common.annotations.Before;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.common.annotations.SystemProperty;
import com.vmware.common.samples.SystemParameters;
import com.vmware.common.samples.parameters.OptionReference;
import com.vmware.common.samples.parameters.Options;
import com.vmware.common.samples.reflection.MethodFinder;
import com.vmware.common.samples.reflection.SmartClassFinder;
import com.vmware.common.samples.registry.ActionReference;
import com.vmware.common.samples.registry.SampleNotFoundException;
import com.vmware.common.samples.registry.SampleReference;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;

public class SampleRegistry {
    public static final int COL_SIZE = 13;
    MethodFinder methodFinder = new MethodFinder();
    private Map<Class<?>, String> lookup = new HashMap();
    private Map<String, SampleReference> registry;
    final String format;
    final String help;
    final SystemParameters systemParameters;
    final Boolean useSampleName;

    public SampleRegistry(SystemParameters systemParameters) {
        this(systemParameters, "%1", "--help");
    }

    public SampleRegistry(SystemParameters systemParameters, String help) {
        this(systemParameters, SampleRegistry.format(13), help);
    }

    public SampleRegistry(SystemParameters systemParameters, String format, String help) {
        this.systemParameters = systemParameters;
        this.format = format;
        this.help = help;
        this.lookup = new HashMap();
        this.registry = new LinkedHashMap<String, SampleReference>();
        this.useSampleName = Boolean.valueOf(System.getProperty("samples.use.name", Main.Defaults.SAMPLES_USE_NAME));
    }

    public static String format(int size) {
        return "%1$-" + size + "s";
    }

    public int size() {
        return this.registry.size();
    }

    @PostConstruct
    public SampleRegistry init() {
        Class<?>[] classes = SampleRegistry.classList(Sample.class);
        this.registry = this.buildRegistry(classes);
        return this;
    }

    public static Class<?>[] classList(Class<? extends Annotation> annotation) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String rootPackage = System.getProperty("sample.package.name", "com.vmware");
        SmartClassFinder classFinder = new SmartClassFinder((URLClassLoader)classLoader, rootPackage);
        return classFinder.find(classFinder.getClassNames(), annotation);
    }

    public boolean isSample(String sampleName) {
        return this.registry.containsKey(sampleName.toLowerCase()) || this.registry.containsKey(this.trimSampleName(sampleName));
    }

    public String trimSampleName(String sampleNameLong) {
        if (sampleNameLong.endsWith(".")) {
            return "";
        }
        return sampleNameLong.substring(sampleNameLong.lastIndexOf(".") + 1, sampleNameLong.length());
    }

    public boolean isSample(Class<?> clazz) {
        return this.lookup.containsKey(clazz);
    }

    public String[] listSamples() {
        Collection<SampleReference> samples = this.registry.values();
        Object[] refs = new SampleReference[samples.size()];
        refs = samples.toArray(refs);
        Arrays.sort(refs);
        String[] names = new String[refs.length];
        for (int ii = 0; ii < refs.length; ++ii) {
            names[ii] = ((SampleReference)refs[ii]).getName();
        }
        return names;
    }

    public SampleReference describe(String sampleName) throws SampleNotFoundException {
        if (!this.registry.containsKey(sampleName)) {
            throw new SampleNotFoundException(sampleName);
        }
        return this.registry.get(sampleName);
    }

    public SampleReference describe(Class<?> clazz) {
        return this.describe(this.lookup.get(clazz));
    }

    public void usage(PrintStream out) {
        String format = SampleRegistry.format(26);
        out.print("====  " + this.registry.size() + " available samples ====");
        String[] samples = this.listSamples();
        String lastGroup = null;
        int col = 0;
        for (String sampleName : samples) {
            if (!this.group(sampleName).equals(lastGroup)) {
                out.println();
                out.println();
                lastGroup = this.group(sampleName);
                out.println(lastGroup);
                out.print("  ");
                col = 0;
            }
            String string = String.format(format, sampleName + "  ");
            out.print(string);
            if ((col += string.length()) <= 52) continue;
            col = 0;
            out.print("\n  ");
        }
        out.println();
        out.println();
        out.println(System.getProperty("sample.help.footer", "to invoke a command, type its class name. For help type --help at the end of any command."));
    }

    public String group(String sample) {
        return this.describe(sample).getPackage();
    }

    public void help(SampleReference reference, PrintStream out) {
        out.println();
        out.println(reference.getName());
        if (!reference.getDescription().equals("")) {
            out.println(this.columnFormat("\n  ", 5, reference.getDescription().replaceAll("\\s+", " ")));
        }
        for (OptionReference option : reference.listOptions()) {
            out.print("  ");
            out.print(String.format(this.format, option.toString()));
            out.print("  ");
            out.print(String.format(this.format, option.parameter ? "<" + option.name + ">" : " "));
            out.print("  ");
            out.print(String.format(this.format, option.required ? "[required]" : " optional "));
            out.print("  ");
            if (option.description != null) {
                String desc = option.description.length() > 26 ? this.columnFormat("\n\t\t\t\t", 3, option.description.replaceAll("\\s+|\\n+|\\t+", " ").replaceFirst("^\\s+", "")) : option.description;
                out.print(desc);
            }
            out.println();
        }
    }

    private String columnFormat(String delimit, int cols, String description) {
        StringBuffer out = new StringBuffer();
        out.append(delimit);
        int col = 0;
        for (int position = 0; position < description.length(); ++position) {
            char ch = description.charAt(position);
            if (this.near(col, 13 * cols, 12) && ch == ' ') {
                out.append(delimit);
                col = 0;
                continue;
            }
            ++col;
            out.append(ch);
        }
        out.append("\n");
        return out.toString();
    }

    boolean near(int num, int max, int range) {
        return num >= max - range || max <= num;
    }

    public void help(String sampleName, PrintStream out) throws SampleNotFoundException {
        if (sampleName.contains("help")) {
            this.usage(out);
        } else {
            this.help(this.describe(sampleName), out);
        }
    }

    Map<String, SampleReference> buildRegistry(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(Sample.class)) continue;
            SampleReference ref = this.reference(clazz);
            this.register(ref);
        }
        return this.registry;
    }

    public void register(Class<?> sampleClass) throws ClassNotFoundException {
        this.register(this.reference(sampleClass));
    }

    public void register(SampleReference ref) {
        if (this.registry.containsKey(ref.getName())) {
            throw new RegistryException("The name: '" + ref.getName() + "' specified by class: " + ref.getClass().getCanonicalName() + " is already in use!");
        }
        this.registry.put(ref.getName(), ref);
        this.lookup.put(ref.getClass(), ref.getName());
    }

    public SampleReference reference(Class<?> clazz) {
        Sample sample = clazz.getAnnotation(Sample.class);
        String name = this.name(clazz, sample);
        return this.reference(name, sample.description(), clazz);
    }

    String name(Class<?> clazz, Sample sample) {
        return this.useSampleName != false && !"".equals(sample.name()) ? sample.name() : clazz.getSimpleName();
    }

    SampleReference reference(String name, String description, Class<?> sample) {
        Method[] methods;
        Options options = new Options(sample);
        Class<Option> optionAnnotationClass = Option.class;
        for (Method method : methods = this.methodFinder.find(sample, optionAnnotationClass)) {
            Method[] propertySetters;
            Method[] setters;
            Option opt = method.getAnnotation(Option.class);
            Class<?> type = this.determineType(method);
            if (this.isSimpleType(type)) {
                if (opt.systemProperty().length() == 0) {
                    options.option(opt.name(), opt.required(), opt.parameter(), opt.description(), method);
                    continue;
                }
                options.option(opt.name(), opt.systemProperty(), opt.required(), opt.parameter(), opt.description(), method);
                continue;
            }
            for (Method setter : setters = this.methodFinder.find(type, optionAnnotationClass)) {
                Option subopt = setter.getAnnotation(Option.class);
                options.complex(subopt.name(), opt.name(), type, subopt.systemProperty(), subopt.required(), subopt.parameter(), subopt.description(), method, setter);
            }
            for (Method setter : propertySetters = this.methodFinder.find(type, SystemProperty.class)) {
                SystemProperty systemProperty = setter.getAnnotation(SystemProperty.class);
                options.complexSystemProperties(opt.name(), systemProperty.property(), systemProperty.defaultValue(), systemProperty.required(), systemProperty.description(), method, setter, SampleRegistry.lookupType(type));
            }
        }
        this.systemProperties(sample, options);
        ActionReference actionRef = this.findActionMethods(sample, this.methodFinder);
        return new SampleReference(this.systemParameters, name, description, sample, actionRef, options);
    }

    public void systemProperties(Class<?> sample, Options options) {
        Method[] propertyMethods;
        Class<SystemProperty> systemPropertyAnnotationClass = SystemProperty.class;
        for (Method propertyMethod : propertyMethods = this.methodFinder.find(sample, systemPropertyAnnotationClass)) {
            SystemProperty systemProperty = propertyMethod.getAnnotation(SystemProperty.class);
            options.systemProperty(systemProperty.property(), systemProperty.defaultValue(), systemProperty.required(), systemProperty.description(), propertyMethod);
        }
    }

    public boolean isSimpleType(Class<?> type) {
        boolean simple;
        boolean bl = simple = type.equals(String.class) || type.equals(Character.TYPE) || type.equals(Character.class);
        if (!simple) {
            try {
                Constructor<?> constructor = type.getConstructor(String.class);
                simple = constructor != null;
            }
            catch (SecurityException e) {
                simple = false;
            }
            catch (NoSuchMethodException e) {
                simple = false;
            }
        }
        return simple;
    }

    public Class<?> determineType(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1) {
            throw new RegistryException(String.format("The setter method %s.%s takes %d arguments! Setters may only specify 1 and only 1 argument.", method.getDeclaringClass().getName(), method.getName(), params.length));
        }
        Class<?> found = SampleRegistry.map(params[0]);
        return found;
    }

    public static Class<?> map(Class<?> type) {
        Class mapped = type;
        Class[] source = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
        Class[] output = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class};
        for (int i = 0; i < source.length; ++i) {
            if (!source[i].equals(type)) continue;
            mapped = output[i];
        }
        return mapped;
    }

    public static Class<?> lookupType(Class<?> type) {
        String typeName = System.getProperty(type.getCanonicalName(), type.getCanonicalName());
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("The class %s could not be found.", type.getCanonicalName()), e);
        }
    }

    ActionReference findActionMethods(Class<?> sample, MethodFinder methodFinder) {
        Class[] actions = new Class[]{Before.class, Action.class, After.class};
        Method[] actionRef = new Method[actions.length];
        for (int ii = 0; ii < actions.length; ++ii) {
            Method[] actionMethods = methodFinder.find(sample, actions[ii]);
            if (actionMethods.length <= 0) continue;
            actionRef[ii] = actionMethods[0];
        }
        return new ActionReference(actionRef[0], actionRef[1], actionRef[2]);
    }

    public boolean isBareSample(String name) {
        return this.isSample(name) && this.noRequiredParams(name);
    }

    public boolean noRequiredParams(String name) {
        if (this.noParams(name)) {
            return true;
        }
        boolean required = false;
        for (OptionReference option : this.describe(name).listOptions()) {
            required |= option.required;
        }
        return !required;
    }

    private boolean noParams(String name) {
        return this.describe(name).listOptions().size() == 0;
    }

    public String getSampleName(String className) {
        try {
            Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            if (clazz.isAnnotationPresent(Sample.class)) {
                Sample sample = clazz.getAnnotation(Sample.class);
                return this.name(clazz, sample);
            }
            return this.help;
        }
        catch (ClassNotFoundException e) {
            return className;
        }
    }

    public class RegistryException
    extends IllegalStateException {
        private static final long serialVersionUID = 4790527743238997636L;

        public RegistryException(String message) {
            super(message);
        }
    }
}

